/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ManageCustomBindingFilesCommand
extends AbstractDataModelOperation {
    protected String[] bindingFiles = null;
    private IProject project = null;
    private String wsdlURI;
    private boolean defineBindingFiles;
    private WebServicesParser webServicesParser;
    private HashSet<String> ignoreList;
    private HashMap<String, String> fileName2URL;
    private boolean trace = Activator.isTraceMode();

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.defineBindingFiles || this.bindingFiles == null || this.bindingFiles.length == 0) {
            return Status.OK_STATUS;
        }
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        this.setupFileLink();
        File tempDir = PlatformUtil.createTempDir((IProject)this.project);
        int i = 0;
        while (i < this.bindingFiles.length) {
            String outputFileName = this.getOutputFileName(tempDir, this.bindingFiles[i]);
            if (outputFileName == null) {
                if (this.trace) {
                    IStatus status = StatusUtils.infoStatus((String)("Cannot write binding file " + this.bindingFiles[i] + " to the temp directory, using the original file."));
                    Activator.getDefault().getLog().log(status);
                }
            } else {
                CustomBindingWsdlLocationHandler bindingHandler = new CustomBindingWsdlLocationHandler(this.bindingFiles[i], outputFileName, this.wsdlURI);
                IStatus status = bindingHandler.execute();
                if (status.getSeverity() == 0) {
                    this.bindingFiles[i] = outputFileName;
                    if (this.trace) {
                        IStatus infoStatus = StatusUtils.infoStatus((String)("Successful in creating " + outputFileName + " in the temp directory, substitute it for the original file " + this.bindingFiles[i]));
                        Activator.getDefault().getLog().log(infoStatus);
                    }
                } else if (this.trace) {
                    Activator.getDefault().getLog().log(status);
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private void setupFileLink() {
        block2: {
            this.fileName2URL = new HashMap();
            this.ignoreList = new HashSet();
            Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            definition.getImports();
            try {
                this.processWSDL(this.wsdlURI, definition);
            }
            catch (Exception e) {
                if (!this.trace) break block2;
                IStatus errorStatus = StatusUtils.errorStatus((Throwable)e);
                Activator.getDefault().getLog().log(errorStatus);
            }
        }
    }

    private void processWSDL(String uri) throws Exception {
        try {
            Definition definition = this.webServicesParser.getWSDLDefinitionVerbose(uri);
            this.processWSDL(uri, definition);
        }
        catch (WSDLException wSDLException) {
            this.processXMLSchema(uri);
        }
    }

    private void processWSDL(String uri, Definition definition) throws Exception {
        uri = this.normalize(uri);
        String baseURI = this.getBaseURI(uri);
        if (!this.needToCopy(uri)) {
            return;
        }
        this.updateTable(this.getLocalname(uri), uri);
        Map imports = definition.getImports();
        for (List list : imports.values()) {
            for (Import wsdlImport : list) {
                IStatus infoStatus;
                String wsdlImportURI = wsdlImport.getLocationURI();
                if (this.isRelative(wsdlImportURI)) {
                    if (this.trace) {
                        infoStatus = StatusUtils.infoStatus((String)("Processing relative wsdl " + wsdlImportURI));
                        Activator.getDefault().getLog().log(infoStatus);
                    }
                    String importBaseURI = new StringBuffer(baseURI).append(wsdlImportURI).toString();
                    this.processWSDL(importBaseURI);
                    continue;
                }
                if (!this.trace) continue;
                infoStatus = StatusUtils.infoStatus((String)("Non relative wsdl, ignoring " + wsdlImportURI));
                Activator.getDefault().getLog().log(infoStatus);
            }
        }
        Types types = definition.getTypes();
        if (types != null) {
            List schemas = types.getExtensibilityElements();
            for (ExtensibilityElement extElement : schemas) {
                XSDSchema xsdSchema;
                UnknownExtensibilityElement schemaElement;
                if (extElement instanceof UnknownExtensibilityElement) {
                    schemaElement = (UnknownExtensibilityElement)extElement;
                    xsdSchema = null;
                    try {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    }
                    catch (Throwable throwable) {}
                    this.processXMLSchema(xsdSchema, baseURI);
                    continue;
                }
                if (!(extElement instanceof XSDSchemaExtensibilityElementImpl)) continue;
                schemaElement = (XSDSchemaExtensibilityElementImpl)extElement;
                xsdSchema = null;
                try {
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                }
                catch (Throwable throwable) {}
                this.processXMLSchema(xsdSchema, baseURI);
            }
        }
    }

    private void processXMLSchema(String uri) throws Exception {
        if (!this.needToCopy(uri = this.normalize(uri))) {
            return;
        }
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)uri);
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream((String)uri);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        if (xsdSchema != null) {
            this.updateTable(this.getLocalname(uri), uri);
            this.processXMLSchema(xsdSchema, this.getBaseURI(uri));
        }
    }

    private void processXMLSchema(XSDSchema xsdSchema, String baseURI) throws Exception {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            for (Object content : xsdSchemaContents) {
                IStatus infoStatus;
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)content;
                String xsdSchemaDirectiveLocation = xsdSchemaDirective.getSchemaLocation();
                if (xsdSchemaDirectiveLocation != null && this.isRelative(xsdSchemaDirectiveLocation)) {
                    if (this.trace) {
                        infoStatus = StatusUtils.infoStatus((String)("Processing non relative schema " + xsdSchemaDirectiveLocation));
                        Activator.getDefault().getLog().log(infoStatus);
                    }
                    String directiveURI = new StringBuffer(baseURI).append(xsdSchemaDirectiveLocation).toString();
                    this.processXMLSchema(directiveURI);
                    continue;
                }
                if (!this.trace) continue;
                infoStatus = StatusUtils.infoStatus((String)("Non relative schema, ignoring " + xsdSchemaDirectiveLocation));
                Activator.getDefault().getLog().log(infoStatus);
            }
        }
    }

    private void updateTable(String fileName, String uri) {
        if (this.fileName2URL.containsKey(fileName)) {
            this.fileName2URL.put(fileName, null);
            if (this.trace) {
                IStatus infoStatus = StatusUtils.infoStatus((String)("File " + fileName + " already exists in table, deleted."));
                Activator.getDefault().getLog().log(infoStatus);
            }
        } else {
            this.fileName2URL.put(fileName, uri);
            if (this.trace) {
                IStatus infoStatus = StatusUtils.infoStatus((String)("Adding " + fileName + " to table, mapping to " + uri));
                Activator.getDefault().getLog().log(infoStatus);
            }
        }
    }

    private boolean needToCopy(String normalizedURI) {
        if (this.ignoreList.contains(normalizedURI)) {
            return false;
        }
        this.ignoreList.add(normalizedURI);
        return true;
    }

    private String normalize(String uri) {
        boolean normalized = false;
        while (!normalized) {
            int dir = uri.indexOf("/..");
            if (dir == -1) {
                normalized = true;
                continue;
            }
            String first = uri.substring(0, dir);
            String second = uri.substring(dir + 3);
            int newIndex = first.lastIndexOf("/");
            if (newIndex == -1) {
                normalized = true;
                continue;
            }
            first = first.substring(0, newIndex);
            uri = String.valueOf(first) + second;
        }
        if (uri.indexOf(" ") != -1) {
            uri = uri.replaceAll(" ", "%20");
        }
        return uri;
    }

    private boolean isRelative(String uri) {
        return uri.indexOf(58) == -1;
    }

    private String getBaseURI(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(0, index + 1);
        }
        return null;
    }

    private String getLocalname(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(index + 1);
        }
        return uri;
    }

    private String getOutputFileName(File tempDir, String inputFileName) {
        int slashCnt;
        int fileSeparatorCnt;
        int startIndex;
        StringBuffer sb = new StringBuffer(tempDir.getAbsolutePath());
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        int n = startIndex = (fileSeparatorCnt = inputFileName.lastIndexOf(File.separatorChar)) >= (slashCnt = inputFileName.lastIndexOf("/")) ? fileSeparatorCnt : slashCnt;
        if (startIndex > 0) {
            String simpleFileName = inputFileName.substring(startIndex + 1);
            sb.append(simpleFileName);
            try {
                File file = new File(sb.toString());
                while (file.exists()) {
                    sb = new StringBuffer(tempDir.getAbsolutePath());
                    if (!sb.toString().endsWith(File.separator)) {
                        sb.append(File.separator);
                    }
                    sb.append(this.getNewFileName(simpleFileName));
                    file = new File(sb.toString());
                }
            }
            catch (Exception exception) {}
            return sb.toString();
        }
        return null;
    }

    private String getNewFileName(String fileName) {
        String extension = null;
        StringBuffer sb = new StringBuffer();
        if (fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf("."));
            sb.append(fileName.substring(0, fileName.lastIndexOf(".") - 1));
        } else {
            sb.append(fileName);
        }
        sb.append("_").append(System.currentTimeMillis());
        if (extension != null) {
            sb.append(extension);
        }
        return sb.toString();
    }

    public String[] getBindingFiles() {
        if (this.defineBindingFiles) {
            return this.bindingFiles;
        }
        return new String[0];
    }

    public void setBindingFiles(String[] bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setDefineBindingFiles(boolean defineBindingFiles) {
        this.defineBindingFiles = defineBindingFiles;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    private class CustomBindingWsdlLocationHandler
    extends DefaultHandler
    implements LexicalHandler {
        boolean fCanonical = false;
        boolean fInCDATA = false;
        protected int fElementDepth;
        protected PrintWriter fOut;
        protected boolean fXML11;
        private String inputFileName = null;
        private String outputFileName = null;
        private String wsdlPath = null;
        protected Locator fLocator;

        public CustomBindingWsdlLocationHandler(String inputFileName, String outputFileName, String wsdlPath) {
            this.inputFileName = inputFileName;
            this.outputFileName = outputFileName;
            this.wsdlPath = wsdlPath;
        }

        public IStatus execute() {
            try {
                try {
                    XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                    FileOutputStream fos = new FileOutputStream(this.outputFileName);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
                    this.fOut = new PrintWriter(writer);
                    parser.setContentHandler(this);
                    parser.setErrorHandler(this);
                    try {
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                        parser.setFeature("http://xml.org/sax/features/namespaces", true);
                        parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    }
                    catch (SAXException sAXException) {}
                    parser.parse(this.inputFileName);
                }
                catch (Exception e) {
                    IStatus errStatus = StatusUtils.errorStatus((String)("Exception in ManageCustomBindingFilesCommand.execute(): " + e.getMessage()), (Throwable)e);
                    Activator.getDefault().getLog().log(errStatus);
                    IStatus iStatus = errStatus;
                    try {
                        if (this.fOut != null) {
                            this.fOut.close();
                        }
                    }
                    catch (Exception exception) {}
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.fOut != null) {
                        this.fOut.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (this.fOut != null) {
                    this.fOut.close();
                }
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }

        public void setDocumentLocator(Locator locator) {
            this.fLocator = locator;
        }

        public void startDocument() throws SAXException {
            this.fElementDepth = 0;
            this.fXML11 = false;
            this.fInCDATA = false;
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.fElementDepth > 0) {
                this.fOut.print("<?");
                this.fOut.print(target);
                if (data != null && data.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(data);
                }
                this.fOut.print("?>");
                this.fOut.flush();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
            if (this.fElementDepth == 0) {
                if (this.fLocator != null) {
                    this.fXML11 = "1.1".equals(this.getVersion());
                    this.fLocator = null;
                }
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                }
            }
            ++this.fElementDepth;
            this.fOut.print('<');
            this.fOut.print(raw);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    IStatus infoStatus;
                    String fileLocalName;
                    String fileName;
                    this.fOut.print(' ');
                    this.fOut.print(attrs.getQName(i));
                    this.fOut.print("=\"");
                    if (this.fElementDepth == 1 && local != null && local.equals("bindings") && attrs.getQName(i) != null && attrs.getQName(i).equals("wsdlLocation")) {
                        fileName = attrs.getValue(i);
                        fileLocalName = ManageCustomBindingFilesCommand.this.getLocalname(fileName);
                        if (ManageCustomBindingFilesCommand.this.fileName2URL.containsKey(fileLocalName) && ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName) != null) {
                            this.normalizeAndPrint((String)ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName), true);
                            if (ManageCustomBindingFilesCommand.this.trace) {
                                infoStatus = StatusUtils.infoStatus((String)("Modifying binding file " + this.inputFileName + " to " + this.outputFileName + " changing \"wsdlLocation\" to " + (String)ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName)));
                                Activator.getDefault().getLog().log(infoStatus);
                            }
                        } else {
                            if (ManageCustomBindingFilesCommand.this.isRelative(fileName)) throw new SAXException(String.valueOf(fileName) + " cannot be found");
                            this.normalizeAndPrint(fileName, true);
                            if (ManageCustomBindingFilesCommand.this.trace) {
                                infoStatus = StatusUtils.infoStatus((String)("Modifying binding file " + this.inputFileName + " to " + this.outputFileName + " maintaining \"wsdlLocation\" as " + fileName));
                                Activator.getDefault().getLog().log(infoStatus);
                            }
                        }
                    } else if (local.equals("bindings") && attrs.getQName(i) != null && attrs.getQName(i).equals("schemaLocation")) {
                        fileName = attrs.getValue(i);
                        fileLocalName = ManageCustomBindingFilesCommand.this.getLocalname(fileName);
                        if (ManageCustomBindingFilesCommand.this.fileName2URL.containsKey(fileLocalName) && ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName) != null) {
                            this.normalizeAndPrint((String)ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName), true);
                            if (ManageCustomBindingFilesCommand.this.trace) {
                                infoStatus = StatusUtils.infoStatus((String)("Modifying binding file " + this.inputFileName + " to " + this.outputFileName + " changing \"schemaLocation\" to " + (String)ManageCustomBindingFilesCommand.this.fileName2URL.get(fileLocalName)));
                                Activator.getDefault().getLog().log(infoStatus);
                            }
                        } else {
                            if (ManageCustomBindingFilesCommand.this.isRelative(fileName)) throw new SAXException(String.valueOf(fileName) + " cannot be found");
                            this.normalizeAndPrint(fileName, true);
                            if (ManageCustomBindingFilesCommand.this.trace) {
                                infoStatus = StatusUtils.infoStatus((String)("Modifying binding file " + this.inputFileName + " to " + this.outputFileName + " maintaining \"schemaLocation\" as " + fileName));
                                Activator.getDefault().getLog().log(infoStatus);
                            }
                        }
                    } else {
                        this.normalizeAndPrint(attrs.getValue(i), true);
                    }
                    this.fOut.print('\"');
                    ++i;
                }
            }
            this.fOut.print('>');
            this.fOut.flush();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.fInCDATA) {
                this.normalizeAndPrint(ch, start, length, false);
            } else {
                int i = 0;
                while (i < length) {
                    this.fOut.print(ch[start + i]);
                    ++i;
                }
            }
            this.fOut.flush();
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
            this.fOut.flush();
        }

        public void endElement(String uri, String local, String raw) throws SAXException {
            --this.fElementDepth;
            this.fOut.print("</");
            this.fOut.print(raw);
            this.fOut.print('>');
            this.fOut.flush();
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
            if (!this.fCanonical) {
                this.fOut.print("<![CDATA[");
                this.fInCDATA = true;
            }
        }

        public void endCDATA() throws SAXException {
            if (!this.fCanonical) {
                this.fInCDATA = false;
                this.fOut.print("]]>");
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.fCanonical && this.fElementDepth > 0) {
                this.fOut.print("<!--");
                int i = 0;
                while (i < length) {
                    this.fOut.print(ch[start + i]);
                    ++i;
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }

        protected void normalizeAndPrint(String s, boolean isAttValue) {
            int len = s != null ? s.length() : 0;
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                this.normalizeAndPrint(c, isAttValue);
                ++i;
            }
        }

        protected void normalizeAndPrint(char[] ch, int offset, int length, boolean isAttValue) {
            int i = 0;
            while (i < length) {
                this.normalizeAndPrint(ch[offset + i], isAttValue);
                ++i;
            }
        }

        protected void normalizeAndPrint(char c, boolean isAttValue) {
            switch (c) {
                case '<': {
                    this.fOut.print("&lt;");
                    break;
                }
                case '>': {
                    this.fOut.print("&gt;");
                    break;
                }
                case '&': {
                    this.fOut.print("&amp;");
                    break;
                }
                case '\"': {
                    if (isAttValue) {
                        this.fOut.print("&quot;");
                        break;
                    }
                    this.fOut.print("\"");
                    break;
                }
                case '\r': {
                    this.fOut.print("&#xD;");
                    break;
                }
                case '\n': {
                    if (this.fCanonical) {
                        this.fOut.print("&#xA;");
                        break;
                    }
                }
                default: {
                    if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                        this.fOut.print("&#x");
                        this.fOut.print(Integer.toHexString(c).toUpperCase());
                        this.fOut.print(";");
                        break;
                    }
                    this.fOut.print(c);
                }
            }
        }

        protected String getVersion() {
            if (this.fLocator == null) {
                return null;
            }
            String version = null;
            Method getXMLVersion = null;
            try {
                getXMLVersion = this.fLocator.getClass().getMethod("getXMLVersion", new Class[0]);
                if (getXMLVersion != null) {
                    version = (String)getXMLVersion.invoke((Object)this.fLocator, null);
                }
            }
            catch (Exception exception) {}
            return version;
        }
    }
}

