/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationContext;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.command.WsGenCommand;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class GenerateDelegateCommand
extends AbstractDataModelOperation {
    private final String NEW_LINE = System.getProperty("line.separator");
    private final String SOAPBINDING_BARE = "@javax.jws.soap.SOAPBinding(parameterStyle = javax.jws.soap.SOAPBinding.ParameterStyle.BARE)";
    private final String SOAPBINDING_RPC = "@javax.jws.soap.SOAPBinding(style = javax.jws.soap.SOAPBinding.Style.RPC)";
    private final String DEFAULTPACKAGE_NS = "http://defaultpackage/";
    private IProject project;
    private boolean genDelegate;
    private boolean genWSDL;
    private IPath outputPath;
    private String implBeanName = null;
    private String delegateName = null;
    private String implBeanNameShort = null;
    private String delegateNameShort = null;
    private WsGenCommand.BINDING_TYPE bindingType;
    private WsGenCommand.BINDING_TYPE bindingTypeImplBean;
    private CodeGenerationContext.JAVA2WSDL_MAPPING mappingStyle;
    private String serviceName;
    private String portName;
    private String targetNameSpace;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.genDelegate) {
            this.delegateName = this.implBeanName;
            return Status.OK_STATUS;
        }
        this.outputPath = J2EEUtil.getJavaSourceLocation((IProject)this.project);
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        this.implBeanNameShort = this.getSimpleClassNameFromQualifyName(this.implBeanName);
        if (this.delegateName == null) {
            this.delegateName = this.getDefaultDelegateClassName(this.implBeanName);
        }
        this.delegateNameShort = this.getSimpleClassNameFromQualifyName(this.delegateName);
        try {
            IType javaType = javaProject.findType(this.implBeanName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String charSet = null;
            try {
                charSet = this.project.getDefaultCharset(true);
            }
            catch (CoreException coreException) {}
            if (charSet == null) {
                charSet = "UTF-8";
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, charSet);
            PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
            this.writePackage(pw, this.getPackageNameFromClassName(this.delegateName));
            if (javaType.isBinary()) {
                IJavaElement[] javaElements;
                IClassFile classFile = javaType.getClassFile();
                IJavaElement[] iJavaElementArray = javaElements = classFile.getChildren();
                int n = javaElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    if (javaElement.getElementType() == 13) {
                        this.writeImport(pw, (IImportDeclaration)javaElement);
                    }
                    ++n2;
                }
            } else {
                ICompilationUnit compilationUnit = javaType.getCompilationUnit();
                IImportDeclaration[] importDeclarations = compilationUnit.getImports();
                int i = 0;
                while (i < importDeclarations.length) {
                    this.writeImport(pw, importDeclarations[i]);
                    ++i;
                }
            }
            this.newLine(pw);
            this.newLine(pw);
            this.writeWebServiceAnnotation(pw);
            this.writeBindingTypeAnnotation(pw);
            this.writeSOAPBindingAnnotation(pw);
            this.writeClassNameDeclaration(pw);
            this.writeClassAttributes(pw);
            boolean hasDefaultConstructor = false;
            boolean isBinary = javaType.isBinary();
            int i = 0;
            while (i < javaType.getMethods().length) {
                IMethod method = javaType.getMethods()[i];
                if (Flags.isPublic((int)method.getFlags())) {
                    if (!method.isConstructor()) {
                        this.writeMethod(pw, method, isBinary);
                    } else if (method.getNumberOfParameters() == 0 && !hasDefaultConstructor) {
                        hasDefaultConstructor = true;
                        this.writeDefaultConstructor(pw, method, isBinary);
                    }
                }
                ++i;
            }
            if (!hasDefaultConstructor) {
                this.writeDefaultConstructor(pw, null, isBinary);
            }
            pw.write("}");
            pw.close();
            baos.close();
            StringBuffer sb = new StringBuffer(this.delegateName.replace('.', '/'));
            sb.append(".java");
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            FileResourceUtils.createFile((ResourceContext)((BaseEclipseEnvironment)this.getEnvironment()).getResourceContext(), (IPath)this.outputPath.append((IPath)new Path(sb.toString())), (InputStream)bais, (IProgressMonitor)monitor, (IStatusHandler)super.getEnvironment().getStatusHandler());
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    private void writePackage(Writer pw, String packageName) throws IOException {
        if (packageName != null) {
            pw.write("package ");
            pw.write(packageName);
            pw.write(";");
            this.newLine(pw);
            this.newLine(pw);
        }
    }

    private void writeImport(Writer pw, IImportDeclaration importDeclaration) throws IOException {
        pw.write("import ");
        pw.write(importDeclaration.getElementName());
        pw.write(";");
        this.newLine(pw);
    }

    private void writeImportByClassName(Writer pw, String className) throws IOException {
        pw.write("import ");
        pw.write(className);
        pw.write(";");
        this.newLine(pw);
    }

    private void writeWebServiceAnnotation(Writer pw) throws IOException {
        pw.write("@javax.jws.WebService (");
        pw.write("targetNamespace=\"");
        if (this.targetNameSpace == null || this.targetNameSpace.length() == 0) {
            String packageName = JavaUtil.getPackageNameFromClassName((String)this.delegateName);
            String serviceNamespace = packageName == null ? "http://defaultpackage/" : JavaUtil.getNamespaceFromPackage((String)packageName);
            pw.write(serviceNamespace);
        } else {
            pw.write(this.targetNameSpace);
        }
        pw.write("\", serviceName=\"");
        if (this.serviceName == null || this.serviceName.length() == 0) {
            pw.write(String.valueOf(this.getSimpleClassNameFromQualifyName(this.implBeanName)) + "Service");
        } else {
            pw.write(this.serviceName);
        }
        pw.write("\", portName=\"");
        if (this.portName == null || this.portName.length() == 0) {
            pw.write(String.valueOf(this.getSimpleClassNameFromQualifyName(this.implBeanName)) + "Port");
        } else {
            pw.write(this.portName);
        }
        if (this.genWSDL) {
            pw.write("\", wsdlLocation=\"WEB-INF/wsdl/");
            if (this.serviceName == null || this.serviceName.length() == 0) {
                pw.write(String.valueOf(this.getSimpleClassNameFromQualifyName(this.implBeanName)) + "Service");
            } else {
                pw.write(this.serviceName);
            }
            pw.write(".wsdl");
        }
        pw.write("\")");
        this.newLine(pw);
    }

    private void writeBindingTypeAnnotation(Writer pw) throws IOException {
        if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP) {
            return;
        }
        pw.write("@javax.xml.ws.BindingType (");
        pw.write("value=");
        if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP12HTTP) {
            pw.write("javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING");
        } else if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM) {
            pw.write("javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_MTOM_BINDING");
        } else if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM) {
            pw.write("javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_MTOM_BINDING");
        }
        pw.write(")");
        this.newLine(pw);
    }

    private void writeSOAPBindingAnnotation(Writer pw) throws IOException {
        if (this.mappingStyle == CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_WRAPPED) {
            return;
        }
        if (this.mappingStyle == CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_BARE) {
            pw.write("@javax.jws.soap.SOAPBinding(parameterStyle = javax.jws.soap.SOAPBinding.ParameterStyle.BARE)");
        } else {
            pw.write("@javax.jws.soap.SOAPBinding(style = javax.jws.soap.SOAPBinding.Style.RPC)");
        }
        this.newLine(pw);
    }

    private void writeClassNameDeclaration(Writer pw) throws IOException {
        pw.write("public class ");
        pw.write(this.delegateNameShort);
        pw.write("{");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeClassAttributes(Writer pw) throws IOException {
        this.indent(pw, 1);
        pw.write(String.valueOf(this.implBeanName) + " " + this.getImplBeanInstanceName(this.implBeanNameShort) + " = null;");
        this.newLine(pw);
        this.newLine(pw);
    }

    private String getImplBeanInstanceName(String implBeanName) {
        return "_" + Character.toLowerCase(implBeanName.charAt(0)) + implBeanName.substring(1);
    }

    private void writeDefaultConstructor(Writer pw, IMethod method, boolean isBinary) throws IOException, JavaModelException {
        this.indent(pw, 1);
        pw.write("public " + this.delegateNameShort + "()");
        if (method != null) {
            this.writeMethodException(pw, method.getExceptionTypes(), isBinary);
        }
        pw.write(" {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write(String.valueOf(this.getImplBeanInstanceName(this.implBeanNameShort)) + " = new " + this.implBeanName + "();");
        pw.write(" }");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethod(Writer pw, IMethod method, boolean isBinary) throws IOException, JavaModelException {
        method.getTypeParameters();
        this.indent(pw, 1);
        pw.write("public ");
        if (isBinary) {
            String sig = Signature.createMethodSignature((String[])method.getParameterTypes(), (String)method.getReturnType());
            pw.write(Signature.toString((String)sig, (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)true, (boolean)true));
        } else {
            pw.write(Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)true, (boolean)true));
        }
        this.writeMethodException(pw, method.getExceptionTypes(), isBinary);
        pw.write(" {");
        this.newLine(pw);
        this.indent(pw, 2);
        if (!method.getReturnType().equals("V")) {
            pw.write("return ");
        }
        pw.write(String.valueOf(this.getImplBeanInstanceName(this.implBeanNameShort)) + "." + method.getElementName() + "(");
        String[] paramNames = method.getParameterNames();
        int i = 0;
        while (i < paramNames.length) {
            if (i < paramNames.length - 1) {
                pw.write(String.valueOf(paramNames[i]) + ",");
            } else {
                pw.write(paramNames[i]);
            }
            ++i;
        }
        pw.write(");");
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethodException(Writer pw, String[] exceptions, boolean isBinary) throws IOException {
        if (exceptions.length == 0) {
            return;
        }
        pw.write(" throws ");
        int i = 0;
        while (i < exceptions.length) {
            if (i != 0) {
                pw.write(", ");
            }
            if (isBinary) {
                String qualifier = Signature.getSignatureQualifier((String)exceptions[i]);
                if (qualifier == null || qualifier.length() == 0) {
                    pw.write(Signature.getSignatureSimpleName((String)exceptions[i]));
                } else {
                    pw.write(String.valueOf(qualifier) + '.' + Signature.getSignatureSimpleName((String)exceptions[i]));
                }
            } else {
                pw.write(Signature.getSignatureSimpleName((String)exceptions[i]));
            }
            ++i;
        }
    }

    private String getDefaultDelegateClassName(String className) {
        if (className != null) {
            return String.valueOf(className) + "Delegate";
        }
        return className;
    }

    private String getPackageNameFromClassName(String className) {
        int lastDot = className.lastIndexOf(".");
        if (lastDot > 0) {
            return className.substring(0, lastDot);
        }
        return null;
    }

    private String getSimpleClassNameFromQualifyName(String className) {
        int lastDot = className.lastIndexOf(".");
        if (lastDot == -1) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    private void newLine(Writer pw) throws IOException {
        pw.write(this.NEW_LINE);
    }

    private void indent(Writer pw, int indentCount) throws IOException {
        int i = 0;
        while (i < indentCount) {
            pw.write("    ");
            ++i;
        }
    }

    public void setIsImplBeanAnnotated(boolean bool) {
        this.genDelegate = !bool;
    }

    public void setGenWSDL(boolean bool) {
        this.genWSDL = bool;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setJavaBeanName(String beanName) {
        this.implBeanName = beanName;
    }

    public String getJavaBeanName() {
        return this.implBeanName;
    }

    public String getDelegateBeanName() {
        return this.delegateName;
    }

    public void setDelegateClass(String className) {
        this.delegateName = className;
    }

    public void setBindingType(WsGenCommand.BINDING_TYPE bt) {
        this.bindingType = bt;
    }

    public WsGenCommand.BINDING_TYPE getBindingType() {
        if (this.genDelegate) {
            return this.bindingType;
        }
        return this.bindingTypeImplBean;
    }

    public void setMappingStyle(CodeGenerationContext.JAVA2WSDL_MAPPING style) {
        this.mappingStyle = style;
    }

    public void setWsdlServiceName(String name) {
        this.serviceName = name;
    }

    public String getWsdlServiceName() {
        return this.serviceName;
    }

    public void setWsdlPortName(String name) {
        this.portName = name;
    }

    public String getWsdlPortName() {
        return this.portName;
    }

    public void setWsdlNameSpace(String ns) {
        this.targetNameSpace = ns;
    }

    public String getWsdlNameSpace() {
        return this.targetNameSpace;
    }

    public void setSoap12(boolean isSoap12) {
        System.out.println("soap12");
        if (isSoap12) {
            if (this.bindingType == null) {
                return;
            }
            if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM) {
                this.bindingType = WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
            } else if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP) {
                this.bindingType = WsGenCommand.BINDING_TYPE.SOAP12HTTP;
            }
        }
    }

    public void setMTOM(boolean isMTOM) {
        if (isMTOM) {
            if (this.bindingType == null) {
                return;
            }
            if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP) {
                this.bindingType = WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
            } else if (this.bindingType == WsGenCommand.BINDING_TYPE.SOAP12HTTP) {
                this.bindingType = WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
            }
        }
    }

    public void setBindingTypeImplBean(WsGenCommand.BINDING_TYPE bindingTypeImplBean) {
        this.bindingTypeImplBean = bindingTypeImplBean;
    }
}

