/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.emitter.command.XjcCommand;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatherJavaToXSDMappingCommand
extends AbstractDataModelOperation {
    private IProject project;
    private boolean genXSDProjects = false;
    private String wsdlURI;
    private HashMap<String, String> classToXSDMap;
    private String[] bindingFiles;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.genXSDProjects) {
            return Status.OK_STATUS;
        }
        XjcCommand xjcCommand = new XjcCommand();
        xjcCommand.setEnvironment(super.getEnvironment());
        xjcCommand.setGenXSDProjects(this.genXSDProjects);
        xjcCommand.setRunAsJob(false);
        xjcCommand.setArgs(this.buildArgs());
        xjcCommand.setProject(this.project);
        IStatus retStatus = xjcCommand.execute(monitor, info);
        if (retStatus.getCode() != 4) {
            this.classToXSDMap = xjcCommand.getClassToXSDMap();
        }
        return Status.OK_STATUS;
    }

    private String[] buildArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(this.createOutputDirectory());
        if (this.bindingFiles != null && this.bindingFiles.length > 0) {
            int i = 0;
            while (i < this.bindingFiles.length) {
                args.add("-b");
                args.add(this.bindingFiles[i]);
                ++i;
            }
        }
        args.add("-wsdl");
        args.add(this.wsdlURI);
        String[] retArray = new String[args.size()];
        retArray = args.toArray(retArray);
        return retArray;
    }

    private String createOutputDirectory() {
        File outputDir = PlatformUtil.createTempDir((IProject)this.project);
        return outputDir.getAbsolutePath();
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public HashMap<String, String> getClassToXSDMap() {
        return this.classToXSDMap;
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.genXSDProjects = genXSDProjects;
    }

    public void setBindingFiles(String[] bindingFiles) {
        this.bindingFiles = bindingFiles;
    }
}

