/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationContext;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.command.WsGenCommand;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class FromJavaInputCommand
extends AbstractDataModelOperation {
    private IWebService ws;
    private String project;
    private String javaBeanName;
    private String outputSrcLocation;
    private String serverInstanceId;
    private String serverFactoryId;
    private CodeGenerationContext context = null;
    private ArrayList validTargetPaths;
    private String targetPath;
    private WebServicesParser webServicesParser;
    private Boolean genWSDL = null;
    private Boolean genWSDDBottomUp = null;
    private Boolean soap12 = null;
    private Boolean mtom = null;
    private String overrideHostName = null;

    public FromJavaInputCommand(IWebService ws, String project) {
        this.ws = ws;
        this.project = project;
        this.initValidTargetPaths();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.serverInstanceId = this.ws.getWebServiceInfo().getServerInstanceId();
        this.serverFactoryId = this.ws.getWebServiceInfo().getServerFactoryId();
        this.javaBeanName = this.ws.getWebServiceInfo().getImplURL();
        this.outputSrcLocation = this.createOutputDirectory();
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        return Status.OK_STATUS;
    }

    private final IStatus initValidTargetPaths() {
        this.targetPath = "";
        JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.validTargetPaths = new ArrayList();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        try {
            try {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
                    IPath targetIPath = packageFragmentRoot.getPath();
                    if (packageFragmentRoot.getKind() == 1) {
                        String targetPathString = targetIPath.toString();
                        this.validTargetPaths.add(targetPathString);
                        boolean hasHiddenDirectories = false;
                        int k = 0;
                        while (k < targetIPath.segmentCount()) {
                            if (targetIPath.segment(k).startsWith(".")) {
                                hasHiddenDirectories = true;
                                break;
                            }
                            ++k;
                        }
                        if (!hasHiddenDirectories) {
                            this.targetPath = targetPathString;
                        } else if (this.targetPath.length() == 0) {
                            this.targetPath = targetPathString;
                        }
                    }
                    ++j;
                }
            }
            catch (JavaModelException e) {
                IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                    this.targetPath = (String)this.validTargetPaths.get(0);
                }
                return iStatus;
            }
        }
        finally {
            if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                this.targetPath = (String)this.validTargetPaths.get(0);
            }
        }
        return Status.OK_STATUS;
    }

    private String createOutputDirectory() {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        File outputDir = PlatformUtil.createTempDir((IProject)iProject);
        return outputDir.getAbsolutePath();
    }

    public String getJavaBeanName() {
        return this.javaBeanName;
    }

    public String getOutputSrcLocation() {
        return this.outputSrcLocation;
    }

    public String getProject() {
        return this.project;
    }

    public ArrayList getValidTargetPaths() {
        return this.validTargetPaths;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setGenWSDL(boolean genWsdl) {
        this.genWSDL = new Boolean(genWsdl);
    }

    public void setSoap12(boolean isSoap12) {
        this.soap12 = new Boolean(isSoap12);
    }

    public void setMTOM(boolean mtom) {
        this.mtom = new Boolean(mtom);
    }

    public boolean getGenWSDL() {
        if (this.genWSDL != null) {
            if (this.soap12 == null || !this.soap12.booleanValue()) {
                return this.genWSDL;
            }
            return true;
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getGenWSDL();
    }

    public void setGenWSDDBottomUp(boolean genWSDDBottomUp) {
        this.genWSDDBottomUp = new Boolean(genWSDDBottomUp);
    }

    public Boolean getGenWSDDBottomUp() {
        if (this.genWSDDBottomUp != null) {
            return (boolean)this.genWSDDBottomUp;
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getGenWSDDBottomUp();
    }

    public WsGenCommand.BINDING_TYPE getBindingType() {
        if (this.mtom != null || this.soap12 != null) {
            if (this.mtom != null && this.soap12 != null) {
                if (this.soap12.booleanValue()) {
                    if (this.mtom.booleanValue()) {
                        return WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
                    }
                    return WsGenCommand.BINDING_TYPE.SOAP12HTTP;
                }
                if (this.mtom.booleanValue()) {
                    return WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
                }
                return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
            }
            if (this.context == null) {
                this.context = Activator.getDefault().getCodeGenerationContext();
            }
            if (this.mtom == null) {
                if (this.soap12.booleanValue()) {
                    if (this.context.getEnableMTOM()) {
                        return WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
                    }
                    return WsGenCommand.BINDING_TYPE.SOAP12HTTP;
                }
                if (this.context.getEnableMTOM()) {
                    return WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
                }
                return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
            }
            if (this.soap12 == null) {
                if (this.mtom.booleanValue()) {
                    if (this.context.getEnableSOAP12()) {
                        return WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
                    }
                    return WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
                }
                if (this.context.getEnableSOAP12()) {
                    return WsGenCommand.BINDING_TYPE.SOAP12HTTP;
                }
                return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
            }
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        if (this.context.getEnableSOAP12()) {
            if (this.context.getEnableMTOM()) {
                return WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
            }
            return WsGenCommand.BINDING_TYPE.SOAP12HTTP;
        }
        if (this.context.getEnableMTOM()) {
            return WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
        }
        return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
    }

    public CodeGenerationContext.JAVA2WSDL_MAPPING getMappingStyle() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getMappingStyle();
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }

    public String getServerFactoryId() {
        return this.serverFactoryId;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public String getOverrideHostName() {
        return this.overrideHostName;
    }

    public void setOverrideHostName(String overrideHostName) {
        this.overrideHostName = overrideHostName;
    }
}

