/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class EnableAsyncMappingCommand
extends AbstractDataModelOperation {
    private String asyncMappingFile;
    private boolean asyncMapping;
    private String wsdlURI;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.asyncMapping) {
            return Status.OK_STATUS;
        }
        File outputDir = PlatformUtil.createTempDir();
        String asyncOutputDir = outputDir.getAbsolutePath();
        StringBuffer sb = new StringBuffer(asyncOutputDir);
        sb.append(File.separator);
        sb.append("asyncMapping.xml");
        this.asyncMappingFile = sb.toString();
        return this.copyTemplateToTemp(this.asyncMappingFile);
    }

    private IStatus copyTemplateToTemp(String outputFileName) {
        try {
            String inputLine;
            FileWriter fw = new FileWriter(outputFileName);
            DataInputStream is = new DataInputStream(Activator.getDefault().getBundle().getEntry("/customMappings/asyncMapping.xml").openStream());
            while ((inputLine = is.readLine()) != null) {
                if (inputLine.indexOf("%WSDLPLACEHOLDER%") != -1) {
                    inputLine = inputLine.replaceAll("%WSDLPLACEHOLDER%", this.wsdlURI.trim().replaceAll(" ", "%20"));
                }
                fw.write(String.valueOf(inputLine) + "\n");
            }
            fw.flush();
            fw.close();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    public void setAsyncMapping(boolean asyncMapping) {
        this.asyncMapping = asyncMapping;
    }

    public boolean getAsyncMapping() {
        return this.asyncMapping;
    }

    public String getAsyncMappingFile() {
        return this.asyncMappingFile;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }
}

