/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.xwt.wsdl.binding.soap12.SOAP12Address;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.WSDLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetermineWsImportExtensionCommand
extends AbstractDataModelOperation {
    private boolean wsimportExtension = false;
    private boolean soap12Binding = false;
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private HashSet<QName> portsWithSOAP12Binding;
    private List<JAXWSWebServiceService> webServices;

    public List<JAXWSWebServiceService> getServices() {
        return this.webServices;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        this.portsWithSOAP12Binding = null;
        this.webServices = new Vector<JAXWSWebServiceService>();
        this.buildServiceStructure();
        this.soap12Binding = this.determineSOAP12WSDL();
        if (this.soap12Binding) {
            this.wsimportExtension = true;
            this.buildPort2SOAP12BindingList();
        }
        if (this.wsdlHasUnknownTransport()) {
            this.wsimportExtension = true;
        }
        return Status.OK_STATUS;
    }

    private boolean wsdlHasUnknownTransport() {
        Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
        for (Object binding1 : definition.getBindings().values()) {
            if (binding1 == null) continue;
            Binding binding = (Binding)binding1;
            for (Object extendElementObj : binding.getExtensibilityElements()) {
                WSDLElement extendElement;
                String transport;
                if (!(extendElementObj instanceof WSDLElement) || !"http://schemas.xmlsoap.org/soap/jms".equals(transport = (extendElement = (WSDLElement)extendElementObj).getElement().getAttribute("transport"))) continue;
                return true;
            }
        }
        return false;
    }

    private void buildServiceStructure() {
        Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
        if (definition.getServices() != null) {
            for (Object service1 : definition.getServices().values()) {
                Service service = (Service)service1;
                JAXWSWebServiceService webService = new JAXWSWebServiceService(service.getQName());
                this.webServices.add(webService);
                for (Object port1 : service.getPorts().values()) {
                    Port port = (Port)port1;
                    for (Object soapObj : port.getExtensibilityElements()) {
                        if (!(soapObj instanceof SOAPAddress) && !(soapObj instanceof SOAP12Address)) continue;
                        JAXWSWebServiceBinding wsdlBinding = webService.getBinding(port.getBinding().getQName(), true);
                        JAXWSWebServicePort wsdlPort = new JAXWSWebServicePort(new QName(port.getName()));
                        wsdlPort.setPortType("http");
                        webService.addPort(wsdlBinding, wsdlPort);
                    }
                }
            }
        }
    }

    private boolean determineSOAP12WSDL() {
        Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
        for (Object binding1 : definition.getBindings().values()) {
            if (!this.isSOAP12Binding((Binding)binding1)) continue;
            return true;
        }
        if (definition.getBindings().size() == 0) {
            Map services = definition.getServices();
            for (Service service : services.values()) {
                Map ports = service.getPorts();
                for (Port port : ports.values()) {
                    if (!this.isSOAP12Binding(port.getBinding())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void buildPort2SOAP12BindingList() {
        block4: {
            try {
                this.portsWithSOAP12Binding = new HashSet();
                Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
                Map services = definition.getServices();
                for (Service service : services.values()) {
                    Map ports = service.getPorts();
                    for (Port port : ports.values()) {
                        if (!this.isSOAP12Binding(port.getBinding())) continue;
                        this.portsWithSOAP12Binding.add(new QName(port.getName()));
                    }
                }
            }
            catch (Exception e) {
                if (!Activator.isTraceMode()) break block4;
                Activator.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e));
            }
        }
    }

    private boolean isSOAP12Binding(Binding binding) {
        if (binding == null) {
            return false;
        }
        for (Object extendElementObj : binding.getExtensibilityElements()) {
            WSDLElement extendElement;
            if (!(extendElementObj instanceof WSDLElement) || (extendElement = (WSDLElement)extendElementObj).getElement().getLocalName() == null || !extendElement.getElement().getLocalName().equals("binding") || extendElement.getElement().getNamespaceURI() == null || !extendElement.getElement().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
            return true;
        }
        return false;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public boolean getWsimportExtension() {
        return this.wsimportExtension;
    }

    public void setWsimportExtension(boolean extension) {
        this.wsimportExtension = extension;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public boolean getSoap12Binding() {
        return this.soap12Binding;
    }

    public HashSet<QName> getPortsWithSOAP12Binding() {
        return this.portsWithSOAP12Binding;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }
}

