/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.deployer.ProjectPathResolver;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSchemaProjectsCommand
extends AbstractDataModelOperation {
    private boolean genXSDProjects = false;
    private HashMap<String, String> uriToProjectMap;
    private Hashtable<String, Hashtable<String, Boolean>> allDependencies;
    private HashMap<String, IPath> projectToOutputPathMap;
    private IProject project;
    private String earProjectName;
    private String serverFactoryId;
    private String serverInstanceId;
    private boolean optimized = true;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.genXSDProjects) {
            return Status.OK_STATUS;
        }
        this.projectToOutputPathMap = new HashMap();
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId("template.jst.utility");
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredFacetVersion());
        AssociateModuleWithEARCommand cmd = new AssociateModuleWithEARCommand();
        cmd.setEARProject(this.earProjectName);
        cmd.setEnvironment(super.getEnvironment());
        if (monitor != null) {
            monitor.beginTask(Messages.MSG_PROGRESS_CREATE_SCHEMA_PROJECTS, this.uriToProjectMap.size());
        }
        for (String xsdUri : this.uriToProjectMap.keySet()) {
            String projectName = this.uriToProjectMap.get(xsdUri);
            createProjectCmd.setProjectName(projectName);
            createProjectCmd.execute(monitor, info);
            IPath outputPath = this.getOutputPath(projectName);
            this.projectToOutputPathMap.put(projectName, outputPath);
            cmd.setProject(projectName);
            cmd.execute(monitor, info);
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (!this.optimized) {
            this.initializeProjects(this.allDependencies, monitor);
            this.setupServiceProjectClassPath(monitor);
        } else {
            SetClasspathOperation op = new SetClasspathOperation(this.allDependencies);
            try {
                op.run(monitor);
            }
            catch (Exception e) {
                IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
                return errStatus;
            }
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredFacetVersion() {
        IProjectFacet projectFacetJava = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.wsfp.utility");
        IProjectFacetVersion projJavaFacetVersion = projectFacetJava.getVersion("1.0");
        RequiredFacetVersion reqFacetVersion = new RequiredFacetVersion();
        reqFacetVersion.setAllowNewer(false);
        reqFacetVersion.setProjectFacetVersion(projJavaFacetVersion);
        return new RequiredFacetVersion[]{reqFacetVersion};
    }

    private void initializeProjects(Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph, IProgressMonitor monitor) {
        if (!this.optimized) {
            for (String id : dependenciesGraph.keySet()) {
                Hashtable<String, Boolean> allDependencies = dependenciesGraph.get(id);
                for (String depId : allDependencies.keySet()) {
                    String projectName1 = this.uriToProjectMap.get(id);
                    String projectName2 = this.uriToProjectMap.get(depId);
                    if (projectName1 == null || projectName2 == null) continue;
                    this.setProjectDependency(projectName1, projectName2, monitor);
                }
            }
        } else {
            HashSet<String> projectSetup = new HashSet<String>();
            for (String id : dependenciesGraph.keySet()) {
                Hashtable<String, Boolean> allDependencies = dependenciesGraph.get(id);
                ArrayList<String> depProjectList = new ArrayList<String>();
                String projectName1 = this.uriToProjectMap.get(id);
                if (projectSetup.contains(projectName1)) continue;
                for (String depId : allDependencies.keySet()) {
                    String projectName2 = this.uriToProjectMap.get(depId);
                    if (projectName1 == null || projectName2 == null) continue;
                    depProjectList.add(projectName2);
                }
                this.setProjectsDependency(projectName1, depProjectList, monitor);
                projectSetup.add(projectName1);
            }
        }
    }

    private void setupServiceProjectClassPath(IProgressMonitor monitor) {
        for (String projectName : this.uriToProjectMap.values()) {
            this.setJ2EEProjectDependency(this.project.getName(), projectName, monitor);
        }
    }

    private void setJ2EEProjectDependency(String projectName1, String projectName2, IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(projectName1);
            ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IProject)this.project);
            manifest.mergeClassPath(new String[]{String.valueOf(projectName2) + ".jar"});
            J2EEProjectUtilities.writeManifest((IProject)this.project, (ArchiveManifest)manifest);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setJ2EEProjectDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private void setProjectsDependency(String projectName1, ArrayList<String> projectNames2, IProgressMonitor monitor) {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName1);
        IJavaProject javaProject1 = JavaCore.create((IProject)project1);
        try {
            IClasspathEntry[] classPathEntries = javaProject1.getRawClasspath();
            ArrayList<IClasspathEntry> desiredEntries = new ArrayList<IClasspathEntry>();
            HashSet<String> addedProject = new HashSet<String>();
            for (String projectName2 : projectNames2) {
                if (projectName1.equals(projectName2) || addedProject.contains(projectName2)) continue;
                IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName2);
                IPath desiredPath = project2.getFullPath();
                boolean entryAlreadyExist = false;
                int i = 0;
                while (i < classPathEntries.length) {
                    IPath path;
                    IClasspathEntry classpathEntry = classPathEntries[i];
                    if (classpathEntry.getEntryKind() == 2 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                        entryAlreadyExist = true;
                        break;
                    }
                    ++i;
                }
                if (!entryAlreadyExist) {
                    desiredEntries.add(JavaCore.newProjectEntry((IPath)desiredPath));
                }
                addedProject.add(projectName2);
            }
            int desiredSize = desiredEntries.size();
            if (desiredSize == 0) {
                return;
            }
            IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + desiredSize];
            int loopCnt = 0;
            for (IClasspathEntry desiredEntry : desiredEntries) {
                newClassPathEntries[loopCnt++] = desiredEntry;
            }
            int i = 0;
            while (i < classPathEntries.length) {
                newClassPathEntries[i + desiredSize] = classPathEntries[i];
                ++i;
            }
            javaProject1.setRawClasspath(newClassPathEntries, monitor);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setProjectsDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private void setProjectDependency(String projectName1, String projectName2, IProgressMonitor monitor) {
        if (projectName1.equals(projectName2)) {
            return;
        }
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName1);
        IJavaProject javaProject1 = JavaCore.create((IProject)project1);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName2);
        try {
            IClasspathEntry[] classPathEntries = javaProject1.getRawClasspath();
            IPath desiredPath = project2.getFullPath();
            int i = 0;
            while (i < classPathEntries.length) {
                IPath path;
                IClasspathEntry classpathEntry = classPathEntries[i];
                if (classpathEntry.getEntryKind() == 2 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                    return;
                }
                ++i;
            }
            IClasspathEntry thinClientClassPathEntry = JavaCore.newProjectEntry((IPath)desiredPath);
            IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + 1];
            newClassPathEntries[0] = thinClientClassPathEntry;
            int i2 = 0;
            while (i2 < classPathEntries.length) {
                newClassPathEntries[i2 + 1] = classPathEntries[i2];
                ++i2;
            }
            javaProject1.setRawClasspath(newClassPathEntries, monitor);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setProjectDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private IPath getOutputPath(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ProjectPathResolver pathResolver = new ProjectPathResolver(javaProject);
        pathResolver.initValidTargetPaths();
        String targetPath = pathResolver.getTargetPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(targetPath).getFullPath();
    }

    public void setUriToProjectMap(HashMap<String, String> uriToProjectMap) {
        this.uriToProjectMap = uriToProjectMap;
    }

    public HashMap<String, IPath> getProjectToOutputPathMap() {
        return this.projectToOutputPathMap;
    }

    public void setAllDependencies(Hashtable<String, Hashtable<String, Boolean>> allDependencies) {
        this.allDependencies = allDependencies;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.genXSDProjects = genXSDProjects;
    }

    private void modifyAutoBuild(boolean isAutoBuild) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(isAutoBuild);
            workspace.setDescription(workspaceDesc);
        }
        catch (Exception exception) {}
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetClasspathOperation
    extends WorkspaceModifyOperation {
        private IStatus status;
        Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph;

        SetClasspathOperation(Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph) {
            this.dependenciesGraph = dependenciesGraph;
        }

        protected void execute(IProgressMonitor monitor) {
            CreateSchemaProjectsCommand.this.initializeProjects(this.dependenciesGraph, monitor);
            CreateSchemaProjectsCommand.this.setupServiceProjectClassPath(monitor);
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

