/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.jaxws.emitter.util.WSDLCopierUtil;
import com.ibm.xwt.wsdl.binding.soap12.SOAP12Address;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.eclipse.wst.wsdl.internal.impl.UnknownExtensibilityElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrectWSDLEndpointAddressCommand
extends AbstractDataModelOperation {
    private final String SERVICES_STR = "services";
    private final String SOAP12_NS_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private IProject webProject;
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String guessedWebProjectURL;
    private WebServiceInfo serviceInfo;
    private String originalOutputWsdlURI;
    private Hashtable<QName, List<QName>> servicePortsMapping;
    private boolean omitWSDLCopying = false;

    public CorrectWSDLEndpointAddressCommand(WebServiceInfo info) {
        this.serviceInfo = info;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            String projectURL = null;
            if (this.guessedWebProjectURL == null) {
                return Status.OK_STATUS;
            }
            if (this.omitWSDLCopying) {
                return Status.OK_STATUS;
            }
            if (this.webServicesParser == null) {
                this.webServicesParser = new WebServicesParserExt(this.wsdlURI);
            }
            String serverInstanceId = this.serviceInfo.getServerInstanceId();
            IServer server = ServerCore.findServer((String)serverInstanceId);
            if (this.webProject != null) {
                projectURL = server != null ? ServerUtils.getWebComponentURL((IProject)this.webProject, null, (IServer)server) : ServerUtils.getEncodedWebComponentURL((IProject)this.webProject, null);
            }
            if (projectURL == null || projectURL.trim().length() == 0) {
                return Status.OK_STATUS;
            }
            if (!this.guessedWebProjectURL.endsWith("/")) {
                this.guessedWebProjectURL = String.valueOf(this.guessedWebProjectURL) + "/";
            }
            if (!projectURL.endsWith("/")) {
                projectURL = String.valueOf(projectURL) + "/";
            }
            if (this.wsdlURI != null && this.wsdlURI.startsWith("platform:")) {
                this.wsdlURI = PlatformUtil.getFileURLFromPlatform((String)this.wsdlURI);
            }
            Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            Map services = definition.getServices();
            for (Service ser : services.values()) {
                Map ports = ser.getPorts();
                block3: for (Port p : ports.values()) {
                    for (Object obj : p.getExtensibilityElements()) {
                        String locationURI;
                        List<QName> modelPorts;
                        SOAPAddress soapAddress;
                        boolean mPortsFlag = false;
                        if (obj instanceof SOAPAddress) {
                            List<QName> modelPorts2;
                            soapAddress = (SOAPAddress)obj;
                            String transport = soapAddress.getLocationURI();
                            if (transport.startsWith("jms")) continue;
                            mPortsFlag = this.servicePortsMapping != null ? (modelPorts2 = this.servicePortsMapping.get(ser.getQName())) != null && modelPorts2.size() > 1 : ports.size() > 1;
                            String locationURI2 = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                            soapAddress.setLocationURI(locationURI2);
                            continue block3;
                        }
                        if (obj instanceof SOAP12Address) {
                            soapAddress = (SOAP12Address)obj;
                            mPortsFlag = this.servicePortsMapping != null ? (modelPorts = this.servicePortsMapping.get(ser.getQName())) != null && modelPorts.size() > 1 : ports.size() > 1;
                            locationURI = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                            soapAddress.setLocationURI(locationURI);
                            continue block3;
                        }
                        if (!(obj instanceof UnknownExtensibilityElementImpl)) continue;
                        UnknownExtensibilityElementImpl unknownElmt = (UnknownExtensibilityElementImpl)obj;
                        unknownElmt.getElement().getNodeName();
                        if (!unknownElmt.getElement().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                        mPortsFlag = this.servicePortsMapping != null ? (modelPorts = this.servicePortsMapping.get(ser.getQName())).size() > 1 : ports.size() > 1;
                        locationURI = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                        unknownElmt.getElement().setAttribute("location", locationURI);
                        continue block3;
                    }
                }
            }
            super.getEnvironment();
            WSDLCopier wsdlCopier = new WSDLCopier(this.webServicesParser);
            wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI), definition);
            if (this.originalOutputWsdlURI != null) {
                wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.originalOutputWsdlURI)));
                wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.originalOutputWsdlURI));
            } else {
                wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.wsdlURI)));
                wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.wsdlURI));
            }
            IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
            if (status != null && status.getSeverity() == 4) {
                System.err.println(status.getMessage());
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    protected String getLocationURI(String serviceName, Port port, boolean multiports, String projectURL) {
        StringBuffer serviceURL = new StringBuffer();
        serviceURL.append(projectURL);
        if (!projectURL.endsWith("/")) {
            serviceURL.append("/");
        }
        if (multiports) {
            serviceURL.append("services/");
            serviceURL.append(port.getName());
        } else {
            serviceURL.append(serviceName);
        }
        return serviceURL.toString();
    }

    public void setProject(IProject webProject) {
        this.webProject = webProject;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        if (webServicesParser != null) {
            this.webServicesParser = webServicesParser;
        }
    }

    public void setGuessedWebProjectURL(String s) {
        if (s != null) {
            this.guessedWebProjectURL = s;
        }
    }

    public void setTempGuessedWebProjectURL(String s) {
        this.setGuessedWebProjectURL(s);
    }

    public void setDestWsdlURI(String wsdlURI) {
        if (wsdlURI != null) {
            this.wsdlURI = wsdlURI;
        }
    }

    public void setTempDestWsdlURI(String wsdlURI) {
        this.setDestWsdlURI(wsdlURI);
    }

    public void setOriginalOutputWsdlURI(String originalOutputWsdlURI) {
        if (originalOutputWsdlURI != null) {
            this.originalOutputWsdlURI = originalOutputWsdlURI;
        }
    }

    public void setTempOriginalOutputWsdlURI(String originalOutputWsdlURI) {
        this.setOriginalOutputWsdlURI(originalOutputWsdlURI);
    }

    public void setServicePortsMapping(Hashtable<QName, List<QName>> mapping) {
        this.servicePortsMapping = mapping;
    }

    public void setOmitWSDLCopying(boolean omitWSDLCopying) {
        this.omitWSDLCopying = omitWSDLCopying;
    }
}

