/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.CopyWSDLToProjectCommand;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.WSDLCopierUtil;
import java.io.File;
import java.net.URLDecoder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class CopyWSDLToTempFolderCommand
extends CopyWSDLToProjectCommand {
    private boolean developClient = false;
    private boolean testService = false;
    private boolean omitWSDLCopying = false;

    public CopyWSDLToTempFolderCommand(WebServiceInfo info, boolean isBottomUp) {
        super(info, isBottomUp);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.copyWSDL) {
            this.destWsdlURI = null;
            this.omitWSDLCopying = false;
            return Status.OK_STATUS;
        }
        if (!this.developClient && !this.testService) {
            this.omitWSDLCopying = true;
            return Status.OK_STATUS;
        }
        super.getEnvironment();
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        String tmpOutputDir = null;
        if (this.isBottomUp) {
            this.setupWSDLURIForBottomUpScenario();
            this.destWsdlURI = this.wsdlURI;
        } else {
            try {
                File outputDir = PlatformUtil.createTempDir((IProject)this.project);
                StringBuffer sb = new StringBuffer(URLDecoder.decode(outputDir.toURI().toString(), "UTF-8"));
                tmpOutputDir = sb.toString();
                sb.append(CopyWSDLToTempFolderCommand.getWSDLName(this.wsdlURI));
                this.destWsdlURI = sb.toString();
            }
            catch (Exception exception) {}
        }
        this.originalOutputWsdlURI = this.destWsdlURI;
        WSDLCopier wsdlCopier = new WSDLCopier(this.webServicesParser);
        wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI), this.correctEndpointAddressesInWSDL(this.wsdlURI, this.servicePortsMapping));
        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.destWsdlURI)));
        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.destWsdlURI));
        IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
        if (status.getSeverity() == 0) {
            IPath relativePath = wsdlCopier.getRelativePath();
            this.wsdlRelativePath = relativePath.toString();
            if (relativePath.segmentCount() > 1 && !this.isBottomUp) {
                StringBuffer sb = new StringBuffer(tmpOutputDir);
                sb.append(this.wsdlRelativePath);
                this.destWsdlURI = sb.toString();
            }
        }
        return status;
    }

    public void setDevelopClient(boolean developClient) {
        this.developClient = developClient;
    }

    public void setTestService(boolean testService) {
        this.testService = testService;
    }

    public boolean getOmitWSDLCopying() {
        return this.omitWSDLCopying && !this.developClient;
    }
}

