/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.CopyWSDLToProjectCommand;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.WSDLCopierUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;

public class CopyClientWSDLCommand
extends AbstractDataModelOperation {
    private final String WSDL_FOLDER = "wsdl";
    private IProject project = null;
    private boolean copyWSDL = false;
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String wsdlLocation;
    private String wsdlLocationURL;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IVirtualFolder ivFolder;
        if (!this.copyWSDL) {
            return Status.OK_STATUS;
        }
        super.getEnvironment();
        IPath wsdlPath = this.project.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        String infDir = "WEB-INF";
        if (J2EEUtil.isWebProject((IProject)this.project)) {
            ivFolder = J2EEUtil.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
            wsdlPath = wsdlPath.append("wsdl");
            wsdlPath = wsdlPath.append(CopyWSDLToProjectCommand.getWSDLName(this.wsdlURI));
        } else if (J2EEUtil.isEJBProject((IProject)this.project) || J2EEUtil.isAppClientProject((IProject)this.project) || J2EEUtil.isJavaUtilityProject((IProject)this.project)) {
            ivFolder = null;
            ivFolder = J2EEUtil.isEJBProject((IProject)this.project) ? J2EEUtil.getEJBDeploymentDescriptorFolder((IVirtualComponent)component) : (J2EEUtil.isAppClientProject((IProject)this.project) ? J2EEUtil.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component) : J2EEUtil.getJavaUtilityDeploymentDescriptorFolder((IVirtualComponent)component));
            wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
            wsdlPath = wsdlPath.append("wsdl");
            wsdlPath = wsdlPath.addTrailingSeparator();
            wsdlPath = wsdlPath.append(CopyWSDLToProjectCommand.getWSDLName(this.wsdlURI));
            infDir = "META-INF";
        } else if (JavaUtil.isUnmanagedProject((IProject)this.project)) {
            IFolder metaInfFolder = this.project.getFolder("META-INF");
            if (!metaInfFolder.exists()) {
                metaInfFolder = null;
                final IFolder[] metaInfFolderHolder = new IFolder[1];
                IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        IFolder metaInfFolder;
                        if (proxy.getName().equals("META-INF") && (metaInfFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(proxy.requestFullPath())).exists()) {
                            metaInfFolderHolder[0] = metaInfFolder;
                            return false;
                        }
                        return true;
                    }
                };
                List srcContainers = JemProjectUtilities.getSourceContainers((IProject)this.project);
                Iterator i = srcContainers.iterator();
                while (i.hasNext()) {
                    try {
                        IContainer srcContainer = (IContainer)i.next();
                        srcContainer.accept(visitor, 0);
                    }
                    catch (CoreException coreException) {}
                    if (metaInfFolderHolder[0] == null) continue;
                    metaInfFolder = metaInfFolderHolder[0];
                    break;
                }
            }
            if (metaInfFolder != null) {
                wsdlPath = metaInfFolder.getFullPath();
            } else {
                wsdlPath = wsdlPath.append(JemProjectUtilities.getSourcePathOrFirst((IProject)this.project, (String)"src").toString());
                wsdlPath = wsdlPath.append("META-INF");
            }
            wsdlPath = wsdlPath.append("wsdl");
            wsdlPath = wsdlPath.addTrailingSeparator();
            wsdlPath = wsdlPath.append(CopyWSDLToProjectCommand.getWSDLName(this.wsdlURI));
            infDir = "META-INF";
        } else {
            this.copyWSDL = false;
            this.wsdlLocation = null;
            this.wsdlLocationURL = null;
            return Status.OK_STATUS;
        }
        String platformWSDLURI = PlatformUtil.getPlatformFromPath((String)wsdlPath.toString());
        WSDLCopier wsdlCopier = new WSDLCopier(this.webServicesParser);
        wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI));
        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)platformWSDLURI)));
        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)platformWSDLURI));
        IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        IPath fullRelativePath = new Path(infDir).append("wsdl").append(wsdlCopier.getRelativePath());
        this.wsdlLocation = fullRelativePath.toString();
        StringBuffer sb = new StringBuffer("/");
        sb.append(fullRelativePath.toString());
        this.wsdlLocationURL = sb.toString();
        return Status.OK_STATUS;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setCopyWSDL(boolean copyWSDL) {
        this.copyWSDL = copyWSDL;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public boolean getCopyWSDL() {
        return this.copyWSDL;
    }

    public String getWsdlLocationURL() {
        return this.wsdlLocationURL;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }
}

