/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.util;

import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EJBRouterComboUtil {
    public static Combo createCombo(Composite parent, String labelText, String tooltipText) {
        String string = tooltipText = tooltipText == null ? labelText : tooltipText;
        if (labelText != null) {
            Label label = new Label(parent, 64);
            label.setText(labelText);
            label.setToolTipText(tooltipText);
        }
        Combo combo = new Combo(parent, 0);
        GridData griddata = new GridData(768);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltipText);
        return combo;
    }

    public static List<IVirtualComponent> getAvailableHttpRouterComponents(String earProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        return EJBRouterComboUtil.getAvailableHttpRouterComponents(earProject);
    }

    public static List<IVirtualComponent> getAvailableHttpRouterComponents(IProject earProject) {
        IVirtualReference[] refList = EarUtilities.getJ2EEModuleReferences((IVirtualComponent)ComponentCore.createComponent((IProject)earProject));
        ArrayList<IVirtualComponent> compList = new ArrayList<IVirtualComponent>(refList.length);
        IVirtualReference[] iVirtualReferenceArray = refList;
        int n = refList.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent referencedComponent = ref.getReferencedComponent();
            if (J2EEUtil.isWebComponent((IVirtualComponent)referencedComponent)) {
                compList.add(referencedComponent);
            }
            ++n2;
        }
        return compList;
    }

    public static List<IVirtualComponent> getAppropriateHttpRouterComponents(String earProjectName, String ejbProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getAppropriateHttpRouterComponents(earProject, ejbProject);
    }

    public static List<IVirtualComponent> getAppropriateJmsRouterComponents(String earProjectName, String ejbProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getAppropriateJmsRouterComponents(earProject, ejbProject);
    }

    public static Hashtable<String, IVirtualComponent> getRouterComponentsForOtherEjbProjects(String earProjectName, String ejbProjectName, String transport) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getRouterComponentsForOtherEjbProjects(earProject, ejbProject, transport);
    }

    public static Hashtable<String, IVirtualComponent> getRouterComponentsForOtherEjbProjects(IProject earProject, IProject ejbProject, String transport) {
        Hashtable<String, IVirtualComponent> routerForOtherEjbProject = new Hashtable<String, IVirtualComponent>();
        List<IVirtualComponent> allEjbComponents = EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
        for (IVirtualComponent ejbComponent : allEjbComponents) {
            if (ejbComponent.getProject().getName().equals(ejbProject.getName())) continue;
            String tmpRouterURI = EJBRouterComboUtil.getDefinedRouterName(ejbComponent.getProject(), transport);
            IVirtualComponent router = null;
            if (tmpRouterURI == null || (router = EJBRouterComboUtil.getComponentByURI(earProject, tmpRouterURI)) == null) continue;
            routerForOtherEjbProject.put(router.getProject().getName(), router);
        }
        return routerForOtherEjbProject;
    }

    public static List<IVirtualComponent> getAppropriateHttpRouterComponents(IProject earProject, IProject ejbProject) {
        ArrayList<IVirtualComponent> returnRouterList = new ArrayList<IVirtualComponent>();
        String routerURI = EJBRouterComboUtil.getDefinedRouterName(ejbProject, "http");
        IVirtualComponent definedRouter = null;
        if (routerURI != null && (definedRouter = EJBRouterComboUtil.getComponentByURI(earProject, routerURI)) != null) {
            returnRouterList.add(definedRouter);
        }
        List<IVirtualComponent> allHttpRouters = EJBRouterComboUtil.getAvailableHttpRouterComponents(earProject);
        Hashtable<String, IVirtualComponent> routerForOtherEjbProject = EJBRouterComboUtil.getRouterComponentsForOtherEjbProjects(earProject, ejbProject, "http");
        for (IVirtualComponent httpRouterComponent : allHttpRouters) {
            String httpRouterProjectName = httpRouterComponent.getProject().getName();
            if (definedRouter != null && definedRouter.getProject().getName().equals(httpRouterProjectName) || routerForOtherEjbProject.containsKey(httpRouterProjectName)) continue;
            returnRouterList.add(httpRouterComponent);
        }
        return returnRouterList;
    }

    public static List<IVirtualComponent> getAppropriateJmsRouterComponents(IProject earProject, IProject ejbProject) {
        ArrayList<IVirtualComponent> returnRouterList = new ArrayList<IVirtualComponent>();
        String routerURI = EJBRouterComboUtil.getDefinedRouterName(ejbProject, "jms");
        IVirtualComponent definedRouter = null;
        if (routerURI != null && (definedRouter = EJBRouterComboUtil.getComponentByURI(earProject, routerURI)) != null) {
            returnRouterList.add(definedRouter);
        }
        List<IVirtualComponent> allJmsRouters = EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
        Hashtable<String, IVirtualComponent> routerForOtherEjbProject = EJBRouterComboUtil.getRouterComponentsForOtherEjbProjects(earProject, ejbProject, "jms");
        for (IVirtualComponent jmsRouterComponent : allJmsRouters) {
            String jmsRouterProjectName = jmsRouterComponent.getProject().getName();
            if (definedRouter != null && definedRouter.getProject().equals((Object)jmsRouterProjectName) || routerForOtherEjbProject.containsKey(jmsRouterProjectName) || ejbProject != null && ejbProject.getName().equals(jmsRouterProjectName)) continue;
            returnRouterList.add(jmsRouterComponent);
        }
        return returnRouterList;
    }

    public static IVirtualComponent getComponentByURI(IProject earProject, String uri) {
        EARArtifactEdit artifactEdit = null;
        IVirtualComponent comp = null;
        try {
            try {
                artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
                comp = artifactEdit.getModuleByManifestURI(uri);
            }
            catch (Exception exception) {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return comp;
    }

    public static String getDefinedRouterName(IProject ejbProject, String transport) {
        WsbndArtifactEdit artifactEdit = null;
        String routerURI = null;
        try {
            try {
                artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)ejbProject);
                WSBinding wsbnd = (WSBinding)artifactEdit.getDeploymentDescriptorRoot();
                EList routers = wsbnd.getRouterModules();
                int i = 0;
                while (i < routers.size()) {
                    RouterModule router = (RouterModule)routers.get(i);
                    if (transport.equals(router.getTransport())) {
                        routerURI = router.getName();
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return routerURI;
    }

    public static List<IVirtualComponent> getAvailableJmsRouterComponents(String earProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        return EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
    }

    public static List<IVirtualComponent> getAvailableJmsRouterComponents(IProject earProject) {
        IVirtualReference[] refList = EarUtilities.getJ2EEModuleReferences((IVirtualComponent)ComponentCore.createComponent((IProject)earProject));
        ArrayList<IVirtualComponent> compList = new ArrayList<IVirtualComponent>(refList.length);
        IVirtualReference[] iVirtualReferenceArray = refList;
        int n = refList.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent referencedComponent = ref.getReferencedComponent();
            if (J2EEUtil.isEJBComponent((IVirtualComponent)referencedComponent)) {
                compList.add(referencedComponent);
            }
            ++n2;
        }
        return compList;
    }

    public static String getSelectedRoutername(Combo routerCombo) {
        return routerCombo.getText();
    }

    public static IProject getSelectedAsProject(Combo routerCombo) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(routerCombo.getText());
        return project;
    }

    public static boolean isSelectedValidRouterProject(Combo routerCombo) {
        return true;
    }

    public static boolean isSelectedvalidRouterProject(Combo routerCombo, int type) {
        return true;
    }
}

