/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.command.UpdateWEBXMLOperation;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateWebXMLCommand
extends UpdateWEBXMLOperation {
    private final String WAS_JAXWS_SERVLET_NAME = "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet";
    private IProject httpRouterProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        Hashtable<String, String> servletClassToMappingTable = this.getServletClassMapping();
        for (String servletClass : servletClassToMappingTable.keySet()) {
            this.addServlet(this.httpRouterProject, servletClass, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet", servletClassToMappingTable.get(servletClass), false);
        }
        return Status.OK_STATUS;
    }

    private Hashtable<String, String> getServletClassMapping() {
        Hashtable<String, String> servletClassMapping = new Hashtable<String, String>();
        for (JAXWSWebServiceService service : this.services) {
            for (JAXWSWebServiceBinding binding : service.getBindings()) {
                for (JAXWSWebServicePort port : binding.getPorts()) {
                    if (!port.getPortType().equals("http")) continue;
                    String portName = port.getPortName().getLocalPart();
                    if (service.isMultiport()) {
                        servletClassMapping.put(String.valueOf(portName) + "Stateless", "services/" + portName);
                        continue;
                    }
                    if (service.getBindings().size() > 1) {
                        servletClassMapping.put(binding.getImplementationBean(), "services/" + portName);
                        continue;
                    }
                    servletClassMapping.put(binding.getImplementationBean(), "/" + service.getServiceName().getLocalPart());
                }
            }
        }
        return servletClassMapping;
    }

    public void setHttpRouterProject(IProject httpRouterProject) {
        this.httpRouterProject = httpRouterProject;
    }
}

