/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.xwt.wsdl.binding.soap12.SOAP12Address;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class DetermineSOAPBindingCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private List<JAXWSWebServiceService> webServices;
    private String JMSLocation;

    public String getJMSLocation() {
        return this.JMSLocation;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        this.webServices = new Vector<JAXWSWebServiceService>();
        this.determineBindingType();
        return Status.OK_STATUS;
    }

    private void determineBindingType() {
        Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
        if (definition.getServices() != null) {
            for (Object service1 : definition.getServices().values()) {
                Service service = (Service)service1;
                JAXWSWebServiceService webService = new JAXWSWebServiceService(service.getQName());
                this.webServices.add(webService);
                for (Object port1 : service.getPorts().values()) {
                    Port port = (Port)port1;
                    for (Object soapObj : port.getExtensibilityElements()) {
                        String soapLocationURI = null;
                        if (soapObj instanceof SOAPAddress) {
                            soapLocationURI = ((SOAPAddress)soapObj).getLocationURI();
                        } else {
                            if (!(soapObj instanceof SOAP12Address)) continue;
                            soapLocationURI = ((SOAP12Address)soapObj).getLocationURI();
                        }
                        JAXWSWebServiceBinding wsdlBinding = webService.getBinding(port.getBinding().getQName(), true);
                        JAXWSWebServicePort wsdlPort = new JAXWSWebServicePort(new QName(port.getName()));
                        if (soapLocationURI != null && soapLocationURI.startsWith("jms:")) {
                            wsdlPort.setPortType("jms");
                            webService.addPort(wsdlBinding, wsdlPort);
                            this.JMSLocation = soapLocationURI;
                            continue;
                        }
                        if (soapLocationURI == null) continue;
                        wsdlPort.setPortType("http");
                        webService.addPort(wsdlBinding, wsdlPort);
                    }
                }
            }
        }
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public List<JAXWSWebServiceService> getServices() {
        return this.webServices;
    }
}

