/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CreateRouterProjectCommand
extends AbstractDataModelOperation {
    private String earProjectName;
    private String ejbProjectName;
    private String httpRouterProjectName;
    private IProject httpProject;
    private String jmsRouterProjectName;
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private String serverInstanceId;
    private String serverFactoryId;
    public static final String WEB_TEMPLATE = "template.jst.web";
    public static final String EJB_TEMPLATE = "template.jst.ejb";

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject jmsProject;
        IWorkspaceRoot root;
        if (this.httpBinding) {
            root = ResourcesPlugin.getWorkspace().getRoot();
            this.httpProject = root.getProject(this.httpRouterProjectName);
            if (!this.httpProject.exists()) {
                IEnvironment env = super.getEnvironment();
                this.createWebProject(env, monitor, adaptable);
                AssociateModuleWithEARCommand associateEarCmd = new AssociateModuleWithEARCommand();
                associateEarCmd.setEnvironment(super.getEnvironment());
                associateEarCmd.setEARProject(this.earProjectName);
                associateEarCmd.setProject(this.httpRouterProjectName);
                associateEarCmd.execute(monitor, adaptable);
            }
        }
        if (this.jmsBinding && !(jmsProject = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(this.jmsRouterProjectName)).exists()) {
            IEnvironment env = super.getEnvironment();
            this.createEjbProject(env, monitor, adaptable);
            AssociateModuleWithEARCommand associateEarCmd = new AssociateModuleWithEARCommand();
            associateEarCmd.setEnvironment(super.getEnvironment());
            associateEarCmd.setEARProject(this.earProjectName);
            associateEarCmd.setProject(this.jmsRouterProjectName);
            associateEarCmd.execute(monitor, adaptable);
        }
        return Status.OK_STATUS;
    }

    private IStatus createWebProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId(WEB_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredWebExtendedFacetVersion());
        createProjectCmd.setProjectName(this.httpRouterProjectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private IStatus createEjbProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId(EJB_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredEjbExtendedFacetVersion());
        createProjectCmd.setProjectName(this.jmsRouterProjectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredWebExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.web", "2.5");
        RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.WEB_COEXISTENCE_FACET_ID, "7.0");
        RequiredFacetVersion reqFacetVersion3 = this.getRequiredFacetVersion(IFacetConstants.WEB_EXTENDED_FACET_ID, "7.0");
        return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2, reqFacetVersion3};
    }

    private RequiredFacetVersion[] getRequiredEjbExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.ejb", "3.0");
        RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.EJB_EXTENDED_FACET_ID, "7.0");
        return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2};
    }

    private RequiredFacetVersion getRequiredFacetVersion(String facetName, String facetVersion) {
        IProjectFacet projectFacetJava = ProjectFacetsManager.getProjectFacet((String)facetName);
        IProjectFacetVersion projJavaFacetVersion = projectFacetJava.getVersion(facetVersion);
        RequiredFacetVersion reqFacetVersion = new RequiredFacetVersion();
        reqFacetVersion.setAllowNewer(false);
        reqFacetVersion.setProjectFacetVersion(projJavaFacetVersion);
        return reqFacetVersion;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setEjbProjectName(String ejbProjectName) {
        this.ejbProjectName = ejbProjectName;
    }

    public void setHttpRouterProjectName(String httpRouterProjectName) {
        this.httpRouterProjectName = httpRouterProjectName;
    }

    public void setJmsRouterProjectName(String jmsRouterProjectName) {
        this.jmsRouterProjectName = jmsRouterProjectName;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.httpBinding = services.get(0).isHTTPBinding();
        this.jmsBinding = services.get(0).isJMSBinding();
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectName;
    }

    public IProject getHttpRouterProject() {
        return this.httpProject;
    }

    public boolean getHttpBinding() {
        return this.httpBinding;
    }

    public boolean getJmsBinding() {
        return this.jmsBinding;
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectName;
    }
}

