/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.jee.project.facet.EJBCreateDeploymentFilesDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class CreateEJBJarXMLCommand
extends AbstractDataModelOperation {
    private IProject project;
    private List<JAXWSWebServiceService> services;
    private EjbFactoryImpl ejbFactory;
    private List<EnterpriseBean> ejbs;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (!this.multiPortServices()) {
            return Status.OK_STATUS;
        }
        EJBArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.project);
                EJBJar ejbJar = artifactEdit.getEJBJar();
                if (ejbJar == null) {
                    IDataModel idm = null;
                    idm = DataModelFactory.createDataModel((IDataModelProvider)new EJBCreateDeploymentFilesDataModelProvider());
                    idm.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project);
                    idm.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)"true");
                    idm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.project);
                ejbJar = artifactEdit.getEJBJar();
                this.ejbs = ejbJar.getEnterpriseBeans();
                this.ejbFactory = new EjbFactoryImpl();
                for (JAXWSWebServiceService service : this.services) {
                    for (JAXWSWebServiceBinding binding : service.getBindings()) {
                        if (!binding.isMultiportBinding()) continue;
                        for (JAXWSWebServicePort port : binding.getPorts()) {
                            this.updateDD(port.getPortName() + "Stateless", binding.getImplementationBean());
                        }
                    }
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                IStatus errorStatus = StatusUtils.errorStatus((Throwable)e);
                this.getEnvironment().getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private void updateDD(String beanName, String implBeanName) {
        Session session = null;
        for (EnterpriseBean existing : this.ejbs) {
            if (!beanName.equals(existing.getName())) continue;
            session = (Session)existing;
        }
        if (session == null) {
            session = this.ejbFactory.createSession();
            this.ejbs.add((EnterpriseBean)session);
        }
        session.setName(beanName);
        session.setEjbClassName(implBeanName);
        session.setSessionType(SessionType.STATELESS_LITERAL);
        session.setTransactionType(TransactionType.CONTAINER_LITERAL);
    }

    private boolean multiPortServices() {
        for (JAXWSWebServiceService service : this.services) {
            if (!service.isMultiport()) continue;
            return true;
        }
        return false;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }
}

