/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.triggers;

import com.ibm.ast.ws.jaxws.annotations.triggers.TriggerUtils;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JwsAnnotationsProvider;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.finder.FinderUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.jar.Attributes;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class V7TriggerUtils
extends TriggerUtils {
    public static final String SCAN_POLICY_QUICKFIX = "scan_policy_quickfix";
    public static final String CREATE_ROUTER_QUICKFIX = "create_router_quickfix";

    private static IRuntime getServerRuntime(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
            if (primaryRuntime != null) {
                return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static boolean useScanPolicy(IProject project) {
        ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IProject)project);
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            String value = attributes.getValue("UseWSFEP61ScanPolicy");
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private static String getSeverityPreference(IProject project) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy servicePolicy = platform.getServicePolicy("com.ibm.ast.ws.jaxws.annotations.v7.jaxws");
        IPolicyStateEnum policyEnum = servicePolicy.getPolicyStateEnum(project);
        String currentStateID = policyEnum.getCurrentItem().getId();
        return currentStateID;
    }

    public static int getSeverity(IProject project) {
        String pref = V7TriggerUtils.getSeverityPreference(project);
        if (pref == null) {
            pref = "com.ibm.ast.ws.jaxws.annotations.v7.default";
        }
        if (V7TriggerUtils.useScanPolicy(project)) {
            return -1;
        }
        if (pref.equals("com.ibm.ast.ws.jaxws.annotations.v7.default")) {
            IRuntime serverRuntime = V7TriggerUtils.getServerRuntime(project);
            if (serverRuntime != null) {
                if (WASRuntimeUtil.isWASv61Runtime((IRuntime)serverRuntime)) {
                    return 1;
                }
                if (WASRuntimeUtil.isWASv70OrLaterRuntime((IRuntime)serverRuntime)) {
                    return 2;
                }
            }
        } else {
            if (pref.equals("com.ibm.ast.ws.jaxws.annotations.v7.warning")) {
                return 1;
            }
            if (pref.equals("com.ibm.ast.ws.jaxws.annotations.v7.error")) {
                return 2;
            }
            if (pref.equals("com.ibm.ast.ws.jaxws.annotations.v7.info")) {
                return 0;
            }
        }
        return -1;
    }

    static boolean shouldHandle(IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || JwsAnnotationsProvider.isClientAnnotation(annotation.getElementName());
    }

    static boolean supportAnnotations(IProject project) {
        return project != null ? FinderUtils.supportAnnotations((IJavaProject)JavaCore.create((IProject)project)) : false;
    }

    static boolean isSupportedEJBProject(IProject project) {
        return project != null ? JavaEEProjectUtilities.isEJBProject((IProject)project) && "5.0".compareTo(J2EEUtil.getJ2EEVersion((IProject)project)) <= 0 && WASRuntimeUtil.isWASv70OrLaterRuntime((IRuntime)V7TriggerUtils.getServerRuntime(project)) : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForStatelessAnnotation(IResource resource) {
        try {
            IType[] types;
            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
            IType[] iTypeArray = types = cu.getTypes();
            int n = types.length;
            int n2 = 0;
            block2: while (true) {
                IAnnotation[] annotations;
                if (n2 >= n) {
                    return false;
                }
                IType type = iTypeArray[n2];
                IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    IAnnotation annotation1 = iAnnotationArray[n4];
                    String annotationElementName = annotation1.getElementName();
                    if ("Stateless".equals(annotationElementName) || "javax.ejb.Stateless".equals(annotationElementName)) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }
}

