/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.triggers;

import com.ibm.ast.ws.jaxws.annotations.triggers.WebServiceSaveTrigger;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobDelegate;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobRunner;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JwsAnnotationsProvider;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.V7TriggerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.ScanPolicyUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

public class ScanPolicySaveTrigger
extends WebServiceSaveTrigger {
    static ScanPolicySaveTrigger instance = new ScanPolicySaveTrigger();
    private String projectName = "";
    private int markerSeverity = -1;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected void addExtraAttributes(Map<String, Object> map) {
        map.put("com.ibm.ast.ws.jaxws.annotations.KIND", "scan_policy_quickfix");
    }

    protected String getMessage() {
        return Messages.TEXT_USE_WSFEP61_SCAN_POLICY;
    }

    protected String getFQName(String annotationName) {
        return JwsAnnotationsProvider.getFQName(annotationName);
    }

    protected boolean shouldTriggerMarker(IAnnotation annotation) {
        if (!V7TriggerUtils.shouldHandle(annotation) || annotation.getParent().getElementType() != 7) {
            return false;
        }
        return super.shouldTriggerMarker(annotation);
    }

    public void annotationAdded(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        final int severity = this.getSeverity(project);
        if (severity == -1) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                ScanPolicySaveTrigger.this.getAnnotationAdder(annotation, severity).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    public void annotationRemoved(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                new WebServiceSaveTrigger.AnnotationRemover((WebServiceSaveTrigger)ScanPolicySaveTrigger.this, annotation).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    public void affectedElement(final IJavaElement affectedElement, IJavaElementDelta delta, String annotationName) {
        if (delta.getKind() != 4 || (delta.getFlags() & 0x40000) == 0) {
            return;
        }
        IResource resource = affectedElement.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                ScanPolicySaveTrigger.this.getAnnotationUpdater(affectedElement).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    protected ArrayList<String> getAnnotationNames() {
        return JwsAnnotationsProvider.getAnnotationNames();
    }

    protected int getSeverity(IProject project) {
        if (!project.getName().equals(this.projectName)) {
            this.projectName = project.getName();
            this.markerSeverity = V7TriggerUtils.getSeverity(project);
        }
        return this.markerSeverity;
    }

    Runnable getAnnotationAdder(IAnnotation annotation, int severity) {
        return new WebServiceSaveTrigger.AnnotationAdder((WebServiceSaveTrigger)this, annotation, severity);
    }

    Runnable getAnnotationUpdater(IJavaElement affectedElement) {
        return new WebServiceSaveTrigger.AnnotationUpdater((WebServiceSaveTrigger)this, affectedElement, "scan_policy_quickfix");
    }
}

