/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.triggers;

import com.ibm.ast.ws.jaxws.annotations.triggers.WebServiceReconcileTrigger;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobDelegate;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobRunner;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JwsAnnotationsProvider;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.ScanPolicySaveTrigger;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.V7TriggerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.ScanPolicyUtils;
import com.ibm.etools.annotations.core.api.TriggerAnnotationsRetriever;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

public class ScanPolicyReconcileTrigger
extends WebServiceReconcileTrigger
implements IResourceChangeListener,
IResourceDeltaVisitor,
IFacetedProjectListener {
    private Object lock = new Object();
    private boolean initialized = false;
    private String projectName = "";
    private int markerSeverity = -1;

    public ScanPolicyReconcileTrigger() {
        super(false);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 17);
        FacetedProjectFramework.addListener((IFacetedProjectListener)this, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
    }

    private int getSeverity(IProject project) {
        if (!project.getName().equals(this.projectName)) {
            this.projectName = project.getName();
            this.markerSeverity = V7TriggerUtils.getSeverity(project);
        }
        return this.markerSeverity;
    }

    protected void addExtraAttributes(Map<String, Object> map) {
        map.put("com.ibm.ast.ws.jaxws.annotations.KIND", "scan_policy_quickfix");
    }

    protected String getMessage() {
        return Messages.TEXT_USE_WSFEP61_SCAN_POLICY;
    }

    protected String getFQName(String annotationName) {
        return JwsAnnotationsProvider.getFQName(annotationName);
    }

    protected boolean shouldTriggerMarker(IAnnotation annotation) {
        if (!V7TriggerUtils.shouldHandle(annotation) || annotation.getParent().getElementType() != 7) {
            return false;
        }
        return super.shouldTriggerMarker(annotation);
    }

    public void annotationAdded(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        final int severity = this.getSeverity(project);
        if (severity == -1) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                new WebServiceReconcileTrigger.AnnotationAdder((WebServiceReconcileTrigger)ScanPolicyReconcileTrigger.this, annotation, severity).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    public void annotationRemoved(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                new WebServiceReconcileTrigger.AnnotationRemover((WebServiceReconcileTrigger)ScanPolicyReconcileTrigger.this, annotation).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        ScanPolicySaveTrigger.instance.setProjectName("");
        if (event.getType() == 1) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.initialized || !(event.getSource() instanceof IWorkspace)) {
                    return;
                }
                this.validateAll();
                this.initialized = true;
            }
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int kind = delta.getKind();
        if (type == 4) {
            IProject project = (IProject)resource;
            if (!ScanPolicyUtils.isPreJEEModule((IProject)project) || !V7TriggerUtils.supportAnnotations(project)) {
                return false;
            }
            if (kind == 1 || kind == 4) {
                this.validate(project);
                return false;
            }
        } else if (type == 1) {
            if (resource.getName().equals("MANIFEST.MF")) {
                switch (kind) {
                    case 4: {
                        if ((delta.getFlags() & 0x100) == 0) break;
                    }
                    case 2: {
                        this.reValidate(resource.getProject());
                        break;
                    }
                    case 1: {
                        this.validate(resource.getProject());
                    }
                }
            } else if ("java".equals(resource.getFileExtension()) && kind == 1) {
                this.validate(resource);
            }
            return false;
        }
        return true;
    }

    public void handleEvent(IFacetedProjectEvent event) {
        IProject project = event.getProject().getProject();
        if (ScanPolicyUtils.isPreJEEModule((IProject)project) && V7TriggerUtils.supportAnnotations(project)) {
            this.reValidate(project);
        }
    }

    private void reValidate(final IProject project) {
        JobDelegate delegate = new JobDelegate((IResource)project){

            @Override
            public void run() throws CoreException {
                IMarker[] markers = project.findMarkers("com.ibm.ast.ws.jaxws.annotations.WSAnnotationMarker", true, 2);
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
                int severity = ScanPolicyReconcileTrigger.this.getSeverity(project);
                if (severity == -1) {
                    return;
                }
                ArrayList<String> names = JwsAnnotationsProvider.getAnnotationNames();
                for (String name : names) {
                    List annotations = TriggerAnnotationsRetriever.getAnnotationsForNonSavedChanges((String)name);
                    for (IAnnotation annotation : annotations) {
                        if (annotation.getResource() == null || !project.equals((Object)annotation.getResource().getProject())) continue;
                        new WebServiceReconcileTrigger.AnnotationAdder((WebServiceReconcileTrigger)ScanPolicyReconcileTrigger.this, annotation, severity).run();
                    }
                    annotations = TriggerAnnotationsRetriever.getAnnotations((String)name);
                    for (IAnnotation annotation : annotations) {
                        if (annotation.getResource() == null || !project.equals((Object)annotation.getResource().getProject())) continue;
                        ScanPolicySaveTrigger.instance.getAnnotationAdder(annotation, severity).run();
                    }
                }
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    private void validate(final IResource resource) {
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
                if (cu.getJavaProject().isOnClasspath((IJavaElement)cu)) {
                    ScanPolicySaveTrigger.instance.getAnnotationUpdater((IJavaElement)cu).run();
                }
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    private void validateCompilationUnits(IProject project) throws JavaModelException {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] pkgFragmentRoots = new IPackageFragmentRoot[]{};
        try {
            pkgFragmentRoots = jProject.getPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {}
        IPackageFragmentRoot[] iPackageFragmentRootArray = pkgFragmentRoots;
        int n = pkgFragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                IJavaElement[] iJavaElementArray = root.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    IPackageFragment pkg = (IPackageFragment)element;
                    ICompilationUnit[] iCompilationUnitArray = pkg.getCompilationUnits();
                    int n5 = iCompilationUnitArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ICompilationUnit cu = iCompilationUnitArray[n6];
                        ScanPolicySaveTrigger.instance.getAnnotationUpdater((IJavaElement)cu).run();
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void validate(final IProject project) {
        JobDelegate delegate = new JobDelegate((IResource)project){

            @Override
            public void run() throws CoreException {
                ScanPolicyReconcileTrigger.this.validateCompilationUnits(project);
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    private void validateAll() {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        WorkspaceJob job = new WorkspaceJob(Messages.MSG_UPDATING_MARKERS){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.setPriority(1);
                }
                IProject[] projects = workspace.getRoot().getProjects();
                int unitsOfWork = projects.length;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)unitsOfWork);
                MultiStatus status = new MultiStatus("com.ibm.ast.ws.jaxws.annotations.v7", 0, null, null);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ScanPolicyUtils.isPreJEEModule((IProject)project) && V7TriggerUtils.supportAnnotations(project)) {
                        block9: {
                            ISchedulingRule rule = workspace.getRuleFactory().markerRule((IResource)project);
                            try {
                                try {
                                    Job.getJobManager().beginRule(rule, (IProgressMonitor)progress);
                                    ScanPolicyReconcileTrigger.this.validateCompilationUnits(project);
                                }
                                catch (JavaModelException e) {
                                    status.add(e.getStatus());
                                    Job.getJobManager().endRule(rule);
                                    break block9;
                                }
                            }
                            catch (Throwable throwable) {
                                Job.getJobManager().endRule(rule);
                                throw throwable;
                            }
                            Job.getJobManager().endRule(rule);
                        }
                        progress.worked(1);
                    }
                    progress.setWorkRemaining(--unitsOfWork);
                    ++n2;
                }
                return status;
            }
        };
        job.setSystem(true);
        job.schedule(1000L);
    }
}

