/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.triggers;

import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobDelegate;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class JobRunner {
    static final JobRunner INSTANCE = new JobRunner();
    private Queue<JobDelegate> queue = new ConcurrentLinkedQueue<JobDelegate>();
    private Job dequeuer = new WorkspaceJob(Messages.MSG_UPDATING_MARKERS){

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.setPriority(1);
            }
            JobDelegate delegate = null;
            while ((delegate = (JobDelegate)JobRunner.this.queue.poll()) != null) {
                ISchedulingRule rule = delegate.getRule();
                try {
                    try {
                        Job.getJobManager().beginRule(rule, monitor);
                        delegate.run();
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.ast.ws.jaxws.annotations.v7", e.getMessage(), (Throwable)e));
                        Job.getJobManager().endRule(rule);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Job.getJobManager().endRule(rule);
                    throw throwable;
                }
                Job.getJobManager().endRule(rule);
            }
            return Status.OK_STATUS;
        }
    };

    private JobRunner() {
        this.dequeuer.setSystem(true);
    }

    void queue(JobDelegate delegate) {
        this.queue.offer(delegate);
        this.dequeuer.schedule(1000L);
    }
}

