/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.triggers;

import com.ibm.ast.ws.jaxws.annotations.triggers.WebServiceSaveTrigger;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobDelegate;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JobRunner;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.JwsAnnotationsProvider;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.V7TriggerUtils;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

public class EjbNoRouterModuleSaveTrigger
extends WebServiceSaveTrigger {
    static EjbNoRouterModuleSaveTrigger instance = new EjbNoRouterModuleSaveTrigger();

    protected void addExtraAttributes(Map<String, Object> map) {
        map.put("com.ibm.ast.ws.jaxws.annotations.KIND", "create_router_quickfix");
    }

    protected String getMessage() {
        return Messages.TEXT_NEED_ROUTER_MODULE;
    }

    protected String getFQName(String annotationName) {
        return JwsAnnotationsProvider.getFQName(annotationName);
    }

    protected boolean shouldTriggerMarker(IAnnotation annotation) {
        IProject project;
        IResource resource;
        if (annotation != null && (resource = annotation.getResource()) != null && V7TriggerUtils.isSupportedEJBProject(project = resource.getProject()) && V7TriggerUtils.checkForStatelessAnnotation(resource) && !this.checkForExistingRouterModule(project)) {
            return super.shouldTriggerMarker(annotation);
        }
        return false;
    }

    public void annotationAdded(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                EjbNoRouterModuleSaveTrigger.this.getAnnotationAdder(annotation, 1).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    public void annotationRemoved(final IAnnotation annotation) {
        IResource resource = annotation.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                new WebServiceSaveTrigger.AnnotationRemover((WebServiceSaveTrigger)EjbNoRouterModuleSaveTrigger.this, annotation).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    public void affectedElement(final IJavaElement affectedElement, IJavaElementDelta delta, String annotationName) {
        if (delta.getKind() != 4 || (delta.getFlags() & 0x40000) == 0) {
            return;
        }
        IResource resource = affectedElement.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (!V7TriggerUtils.supportAnnotations(project)) {
            return;
        }
        JobDelegate delegate = new JobDelegate(resource){

            @Override
            public void run() throws CoreException {
                EjbNoRouterModuleSaveTrigger.this.getAnnotationUpdater(affectedElement).run();
            }
        };
        JobRunner.INSTANCE.queue(delegate);
    }

    protected ArrayList<String> getAnnotationNames() {
        return JwsAnnotationsProvider.getAnnotationNames();
    }

    protected int getSeverity(IProject project) {
        return 1;
    }

    Runnable getAnnotationAdder(IAnnotation annotation, int severity) {
        return new WebServiceSaveTrigger.AnnotationAdder((WebServiceSaveTrigger)this, annotation, severity);
    }

    Runnable getAnnotationUpdater(IJavaElement affectedElement) {
        return new WebServiceSaveTrigger.AnnotationUpdater((WebServiceSaveTrigger)this, affectedElement, "create_router_quickfix");
    }

    private boolean checkForExistingRouterModule(IProject project) {
        boolean routerModuleExists = false;
        WsbndArtifactEdit artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)project);
        if (artifactEdit != null) {
            WSBinding wsbnd = artifactEdit.getWSBinding();
            routerModuleExists = wsbnd.getRouterModules().size() > 0;
            artifactEdit.dispose();
        }
        return routerModuleExists;
    }
}

