/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.servicepolicies;

import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.annotations.v7.triggers.V7TriggerUtils;
import com.ibm.ast.ws.jaxws.emitter.plugin.JaxWSEmitterPlugin;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyStateChangeListener;

public class PolicyStateChangeListener
implements IPolicyStateChangeListener {
    private IProject project;

    public PolicyStateChangeListener() {
        this.project = null;
    }

    public PolicyStateChangeListener(IProject project) {
        this.project = project;
    }

    public void policyStateChange(IServicePolicy policy, String key, String oldValue, String newValue) {
        if ("com.ibm.ast.ws.jaxws.annotations.v7.jaxws216rules".equals(key)) {
            JaxWSEmitterPlugin.getInstance().getPreferencesContext().setExposeMethods_JAXWS216("org.eclipse.wst.true".equals(newValue));
        } else {
            this.preferenceChanged();
        }
    }

    private void updateProjectMarkers(IProject p) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = p.findMarkers("com.ibm.ast.ws.jaxws.annotations.WSProblemMarker", false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                m.setAttribute("severity", V7TriggerUtils.getSeverity(p));
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in PolicyStateChangeListener", (Throwable)e));
        }
    }

    private boolean isApplicableProject(IProject project) {
        if (project.exists() && JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            try {
                if (FacetUtilities.hasWebSphereFacet((IProject)project)) {
                    return true;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in PolicyStateChangeListener", (Throwable)e));
            }
            return true;
        }
        return false;
    }

    public void preferenceChanged() {
        WorkspaceJob job = new WorkspaceJob(Messages.UPDATE_JAXWS_MARKERS_JOB){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.setPriority(1);
                }
                if (PolicyStateChangeListener.this.project == null) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject[] projects = workspace.getRoot().getProjects();
                    int unitsOfWork = projects.length;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)unitsOfWork);
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject p = iProjectArray[n2];
                        if (progress.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (PolicyStateChangeListener.this.isApplicableProject(p)) {
                            PolicyStateChangeListener.this.updateProjectMarkers(p);
                        }
                        progress.worked(1);
                        ++n2;
                    }
                } else {
                    PolicyStateChangeListener.this.updateProjectMarkers(PolicyStateChangeListener.this.project);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

