/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.quickfix;

import com.ibm.ast.ws.jaxws.annotations.quickfix.JavaToWebProjectConverter;
import com.ibm.ast.ws.jaxws.annotations.quickfix.WasRuntimeFacetsModifier;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.annotations.v7.quickfix.JavaToEjbProjectConverter;
import com.ibm.ast.ws.jaxws.emitter.util.ServerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WSMarkerJws21Resolution
implements IMarkerResolution {
    public String getLabel() {
        return Messages.TEXT_ADD_JWS21_QF_INFO;
    }

    public void run(IMarker marker) {
        try {
            JavaToEjbProjectConverter converter;
            int n;
            int n2;
            IAnnotation[] iAnnotationArray;
            IResource resource = marker.getResource();
            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
            IType[] types = cu.getTypes();
            boolean isEjb = false;
            IType[] iTypeArray = types;
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation[] annotations;
                IType type = iTypeArray[n4];
                iAnnotationArray = annotations = type.getAnnotations();
                n2 = annotations.length;
                n = 0;
                while (n < n2) {
                    IAnnotation annotation = iAnnotationArray[n];
                    String annotationElementName = annotation.getElementName();
                    if ("Stateless".equals(annotationElementName) || "javax.ejb.Stateless".equals(annotationElementName)) {
                        isEjb = true;
                        break;
                    }
                    ++n;
                }
                ++n4;
            }
            IProject project = resource.getProject();
            ArrayList<IProjectFacetVersion> facetList = new ArrayList<IProjectFacetVersion>();
            if (isEjb) {
                converter = new JavaToEjbProjectConverter(project, JavaFacetUtils.JAVA_60, IJ2EEFacetConstants.EJB_30);
                converter.convert();
                facetList.add(FacetUtilities.getFacetVersion((String)IFacetConstants.EJB_EXTENDED_FACET_ID, (String)"7.0"));
            } else {
                converter = new JavaToWebProjectConverter(project, JavaFacetUtils.JAVA_60, IJ2EEFacetConstants.DYNAMIC_WEB_25);
                converter.convert();
                facetList.add(FacetUtilities.getFacetVersion((String)IFacetConstants.WEB_COEXISTENCE_FACET_ID, (String)"7.0"));
                facetList.add(FacetUtilities.getFacetVersion((String)IFacetConstants.WEB_EXTENDED_FACET_ID, (String)"7.0"));
            }
            IProjectFacetVersion[] facets = new IProjectFacetVersion[facetList.size()];
            facetList.toArray(facets);
            WasRuntimeFacetsModifier adder = new WasRuntimeFacetsModifier(project, ServerUtils.getWebSphereV7StubRuntime(), facets, null);
            adder.execute();
            if (isEjb) {
                this.addStatelessImport(cu);
            }
            IMarker[] markers = project.findMarkers("com.ibm.ast.ws.jaxws.annotations.WSAnnotationMarker", true, 2);
            iAnnotationArray = markers;
            n2 = markers.length;
            n = 0;
            while (n < n2) {
                IAnnotation m = iAnnotationArray[n];
                m.delete();
                ++n;
            }
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"InvocationTargetException in WSMarkerResolution.run()", (Throwable)e));
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"InterruptedException in WSMarkerResolution.run()", (Throwable)e));
        }
        catch (ExecutionException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"ExecutionException in WSMarkerResolution.run()", (Throwable)e));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in WSMarkerResolution.run()", (Throwable)e));
        }
    }

    private void addStatelessImport(ICompilationUnit cu) {
        final ICompilationUnit fCu = cu;
        IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        final IDocument document = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
        final IProject project = cu.getResource().getProject();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)fCu, (boolean)true);
                    rewrite.addImport("javax.ejb.Stateless");
                    TextEdit edit = rewrite.rewriteImports(null);
                    edit.apply(document);
                    JavaFacetUtils.scheduleFullBuild((IProject)project);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in WSMarkerJws21Resolution.addStatelessImport()", (Throwable)e));
                }
                catch (BadLocationException e) {
                    Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"BadLocationException in WSMarkerJws21Resolution.addStatelessImport()", (Throwable)e));
                }
            }
        });
    }
}

