/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.quickfix;

import com.ibm.ast.ws.jaxws.annotations.quickfix.AddWasTCProposal;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.annotations.v7.quickfix.AddJws21Proposal;
import com.ibm.ast.ws.jaxws.annotations.v7.quickfix.AddRuntimeTargetProposal;
import com.ibm.ast.ws.jaxws.annotations.v7.quickfix.Convert60To70Proposal;
import com.ibm.ast.ws.jaxws.annotations.v7.quickfix.Convert61To70Proposal;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class Jws21QuickFixProcessor
implements IQuickFixProcessor {
    private final void collectProposalsForManagedProjectContext(List<IJavaCompletionProposal> proposalList, IProject project, boolean isWebProject, boolean isEjbProject, boolean isAppClientProject, boolean isUtilityProject, String problemText, IInvocationContext context) {
        boolean canQuickFix = false;
        String autoImportTypeName = null;
        if (problemText.startsWith("javax.jws") || problemText.startsWith("javax.xml.ws") || problemText.startsWith("javax.xml.ws") || problemText.startsWith("javax.xml.bind")) {
            canQuickFix = true;
        } else {
            String packageName = JavaUtil.getPackageForJsr181Type((String)problemText);
            if (packageName == null) {
                packageName = JavaUtil.getPackageForJaxWs21Type((String)problemText);
            }
            if (packageName == null) {
                packageName = (String)JavaUtil.JAXB_20_CLASSES.get(problemText);
            }
            if (packageName != null) {
                canQuickFix = true;
                autoImportTypeName = new StringBuffer(packageName).append('.').append(problemText).toString();
            }
        }
        String jeeVersion = J2EEUtil.getJ2EEVersion((IProject)project);
        if (!"1.4".equals(jeeVersion) && !"5.0".equals(jeeVersion)) {
            canQuickFix = false;
        }
        if (canQuickFix) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
                if (primaryRuntime != null) {
                    IRuntime runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
                    if (WASRuntimeUtil.isWASv61Runtime((IRuntime)runtime)) {
                        if (isWebProject) {
                            proposalList.add(new Convert61To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isEjbProject) {
                            proposalList.add(new Convert61To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isAppClientProject) {
                            proposalList.add(new Convert61To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isUtilityProject) {
                            proposalList.add(new Convert61To70Proposal(project, autoImportTypeName, context, 100));
                        }
                    } else if (WASRuntimeUtil.isWASv60Runtime((IRuntime)runtime)) {
                        if (isWebProject) {
                            proposalList.add(new Convert60To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isEjbProject) {
                            proposalList.add(new Convert60To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isAppClientProject) {
                            proposalList.add(new Convert60To70Proposal(project, autoImportTypeName, context, 100));
                        } else if (isUtilityProject) {
                            proposalList.add(new Convert60To70Proposal(project, autoImportTypeName, context, 100));
                        }
                    }
                } else if (isWebProject) {
                    proposalList.add(new AddRuntimeTargetProposal(project, new IProjectFacetVersion[]{FacetUtilities.getFacetVersion((String)IFacetConstants.WEB_COEXISTENCE_FACET_ID, (String)"7.0"), FacetUtilities.getFacetVersion((String)IFacetConstants.WEB_EXTENDED_FACET_ID, (String)"7.0")}, autoImportTypeName, context, 100));
                } else if (isEjbProject) {
                    proposalList.add(new AddRuntimeTargetProposal(project, new IProjectFacetVersion[]{FacetUtilities.getFacetVersion((String)IFacetConstants.EJB_EXTENDED_FACET_ID, (String)"7.0")}, autoImportTypeName, context, 100));
                } else if (isAppClientProject) {
                    proposalList.add(new AddRuntimeTargetProposal(project, new IProjectFacetVersion[]{FacetUtilities.getFacetVersion((String)IFacetConstants.APPCLIENT_COEXISTENCE_FACET_ID, (String)"7.0"), FacetUtilities.getFacetVersion((String)IFacetConstants.APPCLIENT_EXTENDED_FACET_ID, (String)"7.0")}, autoImportTypeName, context, 100));
                } else if (isUtilityProject) {
                    proposalList.add(new AddRuntimeTargetProposal(project, null, autoImportTypeName, context, 100));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in Jws21QuickFixProcessor.getCorrectionsForManagedProjectContext()", (Throwable)e));
            }
        }
    }

    private final void collectProposalsForJavaProjectContext(List<IJavaCompletionProposal> proposalList, IProject project, String problemText, IInvocationContext context) {
        boolean shouldAddThinClient = false;
        boolean shouldConvertToWebProject = false;
        String autoImportTypeName = null;
        if (JavaUtil.isJaxWs21Package((String)problemText) || JavaUtil.isJaxBPackage((String)problemText)) {
            shouldAddThinClient = true;
        } else if (JavaUtil.isJsr181Package((String)problemText)) {
            shouldConvertToWebProject = true;
        } else {
            String packageName = JavaUtil.getPackageForJaxWs21Type((String)problemText);
            if (packageName == null) {
                packageName = JavaUtil.getPackageForJaxBType((String)problemText);
            }
            if (packageName != null) {
                shouldAddThinClient = true;
                autoImportTypeName = new StringBuffer(packageName).append('.').append(problemText).toString();
            } else {
                packageName = JavaUtil.getPackageForJsr181Type((String)problemText);
                if (packageName != null) {
                    shouldConvertToWebProject = true;
                    autoImportTypeName = new StringBuffer(packageName).append('.').append(problemText).toString();
                }
            }
        }
        if (shouldAddThinClient) {
            proposalList.add((IJavaCompletionProposal)new AddWasTCProposal("com.ibm.ws.ast.st.v7.server.base", project, autoImportTypeName, context, 85, Messages.TEXT_ADD_V7_TC_QF_INFO, Messages.TEXT_ADD_V7_TC_QF_ADD_INFO));
            proposalList.add(new AddJws21Proposal(project, autoImportTypeName, context, 80));
        } else if (shouldConvertToWebProject) {
            proposalList.add(new AddJws21Proposal(project, autoImportTypeName, context, 80));
        }
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> res = new ArrayList<IJavaCompletionProposal>();
        ICompilationUnit icu = context.getCompilationUnit();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            if (this.hasCorrections(icu, problem.getProblemId())) {
                String problemText = icu.getBuffer().getText(problem.getOffset(), problem.getLength());
                IProject project = icu.getResource().getProject();
                boolean isWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
                boolean isEjbProject = JavaEEProjectUtilities.isEJBProject((IProject)project);
                boolean isAppClientProject = JavaEEProjectUtilities.isApplicationClientProject((IProject)project);
                boolean isUtilityProject = JavaEEProjectUtilities.isUtilityProject((IProject)project);
                if (!(isWebProject || isEjbProject || isAppClientProject || isUtilityProject || !ResourceUtils.isJavaProject((IProject)project))) {
                    this.collectProposalsForJavaProjectContext(res, project, problemText, context);
                } else {
                    this.collectProposalsForManagedProjectContext(res, project, isWebProject, isEjbProject, isAppClientProject, isUtilityProject, problemText, context);
                }
            }
            ++n2;
        }
        if (res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 0x1000002 || problemId == 268435846;
    }
}

