/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.quickfix;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.project.facet.ProductManager;

public class JavaToEjbProjectConverter {
    private IProject javaProject_;
    private IProjectFacetVersion javaFacetVersion_;
    private IProjectFacetVersion ejbFacetVersion_;
    private ExecutionException exception_;

    public JavaToEjbProjectConverter(IProject javaProject, IProjectFacetVersion javaFacetVersion, IProjectFacetVersion ejbFacetVersion) {
        this.javaProject_ = javaProject;
        this.javaFacetVersion_ = javaFacetVersion;
        this.ejbFacetVersion_ = ejbFacetVersion;
        this.exception_ = null;
    }

    public void convert() throws InvocationTargetException, InterruptedException, ExecutionException {
        this.exception_ = null;
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                String projectName = JavaToEjbProjectConverter.this.javaProject_.getName();
                IDataModel jdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
                jdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
                jdm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaToEjbProjectConverter.this.javaFacetVersion_);
                IDataModel udm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
                udm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
                udm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaToEjbProjectConverter.this.ejbFacetVersion_);
                udm.setProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", (Object)false);
                udm.setProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", (Object)(String.valueOf(projectName) + ".jar"));
                String configFolder = J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent");
                udm.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)(configFolder != null && configFolder.trim().length() > 0 ? configFolder : ProductManager.getProperty((String)"ejbContent")));
                udm.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", (Object)false);
                IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
                dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
                IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                map.add(jdm);
                map.add(udm);
                try {
                    dm.getDefaultOperation().execute(monitor, null);
                }
                catch (ExecutionException e) {
                    JavaToEjbProjectConverter.this.exception_ = e;
                }
            }
        });
        if (this.exception_ != null) {
            throw this.exception_;
        }
    }
}

