/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.annotations.v7.quickfix;

import com.ibm.ast.ws.jaxws.annotations.quickfix.WasRuntimeFacetsModifier;
import com.ibm.ast.ws.jaxws.annotations.v7.messages.Messages;
import com.ibm.ast.ws.jaxws.annotations.v7.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.ScanPolicyUtils;
import com.ibm.ast.ws.jaxws.emitter.util.ServerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IRuntime;

public class AddRuntimeTargetProposal
implements IJavaCompletionProposal {
    private IProject project_;
    protected ArrayList<String> autoImportTypeNames_;
    protected IInvocationContext context_;
    private int relevance_;
    private ArrayList<IProjectFacetVersion> wasFacetVersions_;

    public AddRuntimeTargetProposal(IProject project, IProjectFacetVersion[] wasFacetVersions, String autoImportTypeName, IInvocationContext context, int relevance) {
        this.project_ = project;
        this.autoImportTypeNames_ = new ArrayList();
        this.autoImportTypeNames_.add(autoImportTypeName);
        this.context_ = context;
        this.relevance_ = relevance;
        this.wasFacetVersions_ = new ArrayList();
        this.wasFacetVersions_.add(JavaFacetUtils.JAVA_60);
        this.addFacetVersions(wasFacetVersions);
    }

    public int getRelevance() {
        return this.relevance_;
    }

    protected void addFacetVersions(IProjectFacetVersion[] facetVersions) {
        if (facetVersions != null) {
            IProjectFacetVersion[] iProjectFacetVersionArray = facetVersions;
            int n = facetVersions.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFacetVersion facetVersion = iProjectFacetVersionArray[n2];
                this.wasFacetVersions_.add(facetVersion);
                ++n2;
            }
        }
    }

    private void addRuntimeAndFacets(IProject project, IRuntime runtime, IProjectFacetVersion[] projectFacetVersions) {
        try {
            WasRuntimeFacetsModifier adder = new WasRuntimeFacetsModifier(project, runtime, projectFacetVersions, null);
            adder.execute();
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"InvocationTargetException in AddWasV7RuntimeTargetProposal.addRuntimeAndFacets()", (Throwable)e));
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"InterruptedException in AddWasV7RuntimeTargetProposal.addRuntimeAndFacets", (Throwable)e));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void apply(IDocument document) {
        int n;
        if (this.wasFacetVersions_ != null) {
            IProjectFacetVersion[] wasFacetVersions = new IProjectFacetVersion[this.wasFacetVersions_.size()];
            this.wasFacetVersions_.toArray(wasFacetVersions);
            this.addRuntimeAndFacets(this.project_, null, wasFacetVersions);
        }
        IProject[] earProjects = EarUtilities.getReferencingEARProjects((IProject)this.project_);
        IRuntime was7Runtime = ServerUtils.getWebSphereV7StubRuntime();
        if (earProjects.length > 0) {
            IProject[] iProjectArray = earProjects;
            n = earProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject earProject = iProjectArray[n2];
                this.addRuntimeAndFacets(earProject, was7Runtime, null);
                ++n2;
            }
        } else {
            this.addRuntimeAndFacets(this.project_, was7Runtime, null);
        }
        if (this.autoImportTypeNames_.size() > 0) {
            final IDocument fDocument = document;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)AddRuntimeTargetProposal.this.context_.getASTRoot(), (boolean)true);
                        for (String autoImportTypeName : AddRuntimeTargetProposal.this.autoImportTypeNames_) {
                            rewrite.addImport(autoImportTypeName);
                        }
                        TextEdit edit = rewrite.rewriteImports(null);
                        edit.apply(fDocument);
                        JavaFacetUtils.scheduleFullBuild((IProject)AddRuntimeTargetProposal.this.project_);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in AddWasV7RuntimeTargetProposal.apply()", (Throwable)e));
                    }
                    catch (BadLocationException e) {
                        Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"BadLocationException in AddWasV7RuntimeTargetProposal.apply()", (Throwable)e));
                    }
                }
            });
        }
        try {
            IMarker[] markers;
            if (ScanPolicyUtils.isPreJEEModule((IProject)this.project_)) {
                ScanPolicyUtils.addScanPolicyAttribute((IProject)this.project_);
            }
            IMarker[] iMarkerArray = markers = this.project_.findMarkers("com.ibm.ast.ws.jaxws.annotations.WSAnnotationMarker", true, 2);
            int n3 = markers.length;
            n = 0;
            while (n < n3) {
                IMarker m = iMarkerArray[n];
                m.delete();
                ++n;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"IOException in AddWasV7RuntimeTargetProposal.apply()", (Throwable)e));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)"CoreException in AddWasV7RuntimeTargetProposal.apply()", (Throwable)e));
        }
    }

    public String getAdditionalProposalInfo() {
        return Messages.TEXT_ADD_WASV7_RUNTIME_TARGET_QF_ADD_INFO;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.TEXT_ADD_WASV7_RUNTIME_TARGET_QF_INFO;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

