/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxrs.util;

import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.libraries.impl.LibrariesFactoryImpl;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import com.ibm.ws.ast.st.enhanced.ear.internal.command.AddSharedLibraryConfigurationCommand;
import com.ibm.ws.ast.st.enhanced.ear.internal.command.SharedLibraryConfiguratorCommand;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.ApplicationConfiguratorModel;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.SharedLibraryConfigurationModel;
import com.ibm.ws.ast.st.enhanced.ear.util.internal.WasDeploymentUtilities;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryRegistryUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class WASJAXRSSharedLibConfigurator {
    public static void installSharedLibs(IProject webProject, IProject earProject, IProgressMonitor monitor, String JAXRSLibraryID) {
        JAXRSLibraryInternalReference lib = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryReferencebyID(JAXRSLibraryID);
        SharedLibraryConfiguratorCommand command = new SharedLibraryConfiguratorCommand();
        ApplicationConfiguratorModel appConfigModel = new ApplicationConfiguratorModel(ComponentCore.createComponent((IProject)earProject));
        SharedLibraryConfigurationModel configModel = appConfigModel.getSharedLibraryConfigModel();
        command.setLibraryConfigModel(configModel);
        LibrariesFactoryImpl factory2 = new LibrariesFactoryImpl();
        Library libraryInfo = factory2.createLibrary();
        libraryInfo.setName(String.valueOf(lib.getLabel()) + " " + Messages.JAXRSLibraryClasspathContainer_IMPL_LIBRARY);
        EList archiveFiles = lib.getArchiveFiles();
        Iterator jars = archiveFiles.iterator();
        while (jars.hasNext()) {
            libraryInfo.getClassPath().add((Object)((ArchiveFile)jars.next()).getResolvedSourceLocation());
        }
        AddSharedLibraryConfigurationCommand cmd = new AddSharedLibraryConfigurationCommand(command, libraryInfo, appConfigModel.getApplDeploymentConfigurationModel());
        cmd.execute();
        appConfigModel.save();
        IFile file = WasDeploymentUtilities.getSingleInstance().findMetaInfFile("ibmconfig/cells/defaultCell/nodes/defaultNode/servers/defaultServer/libraries.xml", earProject);
        if (file != null && file.exists() && file.getResourceAttributes() != null && !file.getResourceAttributes().isReadOnly()) {
            try {
                file.touch(monitor);
            }
            catch (CoreException coreException) {}
        }
    }

    public static boolean sharedLibSupported(IProject webProject, IProject earProject, boolean addToEAR, String JAXRSLibraryID, String sWASVersion) {
        if (!addToEAR) {
            return false;
        }
        if (!earProject.exists()) {
            return true;
        }
        try {
            if (FacetUtilities.hasFacetVersion((IProject)earProject, (String)IFacetConstants.EAR_COEXISTENCE_FACET_ID, (String)sWASVersion) && FacetUtilities.hasFacetVersion((IProject)earProject, (String)IFacetConstants.EAR_EXTENDED_FACET_ID, (String)sWASVersion)) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void unInstallSharedLibs(IProject webProject) {
    }
}

