/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.widgets;

import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxb.ui.widgets.NameValuePairDialog;
import com.ibm.ast.ws.jaxb.ui.widgets.NameValuePairObject;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class XsdFileToProjectMappingWidget
extends SimpleWidgetDataContributor {
    private boolean createEAR = false;
    private int DEFAULT_TABLE_HEIGHT_HINT = 150;
    private int DEFAULT_COLUMN_WIDTH = 180;
    private Table mappingTable;
    private Composite parent_;
    private Listener statusListener_;
    private String targetPath;
    private final String INFOPOP_WSXP_XSDPROJECT_TABLE = "WSXP0000";
    private final String INFOPOP_WSXP_BUTTON_EDIT = "WSXP0001";
    private Button editButton;
    private final String INFOPOP_WSXP_BUTTON_DEFAULT = "WSXP0002";
    private Button restoreDefaultButton;
    private final String INFOPOP_WSXP_COMBO_EAR = "WSXP0003";
    private Combo earCombo;
    private HashMap<String, String> uriToProjectMap;
    private HashMap<String, Boolean> projectExistanceMap = new HashMap();
    private HashMap<String, Boolean> validProjectMap = new HashMap();
    private boolean enableFields = true;

    public XsdFileToProjectMappingWidget() {
    }

    public XsdFileToProjectMappingWidget(boolean createEAR) {
        this();
        this.createEAR = createEAR;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxb.ui");
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        if (this.createEAR) {
            Composite earComposite = uiUtils.createComposite(parent, 2);
            this.earCombo = uiUtils.createCombo(earComposite, Messages.LABEL_EAR_PROJECT, Messages.TOOLTIP_EAR_PROJECT, "WSXP0003", 2052);
            this.populateEarCombo();
            this.earCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XsdFileToProjectMappingWidget.this.statusListener_.handleEvent(null);
                }
            });
        }
        Group mainGroup = uiUtils.createGroup(parent, Messages.LABEL_XSDPROJECT_TABLE, null, "WSXP0000", 2, -1, -1);
        this.mappingTable = uiUtils.createTable((Composite)mainGroup, Messages.LABEL_XSDPROJECT_TABLE, "WSXP0000", 67612);
        String[] columns = new String[]{Messages.LABEL_COLUMN_XSD, Messages.LABEL_COLUMN_PROJECT};
        GridData gd = new GridData(1808);
        gd.heightHint = this.DEFAULT_TABLE_HEIGHT_HINT;
        this.mappingTable.setLayoutData((Object)gd);
        this.mappingTable.setHeaderVisible(true);
        this.mappingTable.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int maxWidth = this.DEFAULT_COLUMN_WIDTH;
        int i = 0;
        while (i < columns.length) {
            TableColumn tableColumn = new TableColumn(this.mappingTable, 0);
            tableColumn.setText(columns[i]);
            tableColumn.pack();
            int tableColumnWidth = Math.max(this.DEFAULT_COLUMN_WIDTH, tableColumn.getWidth());
            maxWidth = Math.max(maxWidth, tableColumnWidth);
            ColumnWeightData columnData = new ColumnWeightData(tableColumnWidth, tableColumnWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        this.mappingTable.setLayout((Layout)tableLayout);
        Composite buttonsCompo = uiUtils.createComposite(parent, 2);
        this.editButton = uiUtils.createPushButton(buttonsCompo, Messages.LABEL_EDIT, null, "WSXP0001");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int selectedRow = XsdFileToProjectMappingWidget.this.mappingTable.getSelectionIndex();
                TableItem itemToEdit = XsdFileToProjectMappingWidget.this.mappingTable.getItem(selectedRow);
                NameValuePairObject object = new NameValuePairObject(itemToEdit.getText(0), itemToEdit.getText(1));
                String oldProjectName = object.getValue();
                NameValuePairDialog dialog = new NameValuePairDialog(XsdFileToProjectMappingWidget.this.parent_.getShell(), Messages.LABEL_XSDPROJECT_TABLE, object, Messages.LABEL_COLUMN_XSD, Messages.LABEL_COLUMN_PROJECT);
                if (dialog.open() == 0) {
                    object = dialog.getData();
                    itemToEdit.setText(new String[]{object.getName(), object.getValue()});
                    XsdFileToProjectMappingWidget.this.updateDuplicateProject(oldProjectName, object.getValue());
                    XsdFileToProjectMappingWidget.this.statusListener_.handleEvent(null);
                }
            }
        });
        this.restoreDefaultButton = uiUtils.createPushButton(buttonsCompo, Messages.LABEL_RESTORE_DEFAULT, Messages.TOOLTIP_RESTORE_DEFAULT_XSDPROJECT, "WSXP0002");
        this.restoreDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                XsdFileToProjectMappingWidget.this.mappingTable.removeAll();
                XsdFileToProjectMappingWidget.this.handleRestore();
            }
        });
        return this;
    }

    public IStatus getStatus() {
        if (!this.enableFields) {
            return StatusUtils.warningStatus((String)Messages.bind((String)Messages.WARNING_NO_SCHEMA_LIBRARY_GEN, (Object[])new String[]{this.targetPath}));
        }
        IStatus retStatus = this.validateValidProjectType();
        if (retStatus.getSeverity() != 0) {
            return retStatus;
        }
        retStatus = this.validateProjectsExistance();
        if (retStatus.getSeverity() != 0) {
            return retStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus validateValidProjectType() {
        int i = 0;
        while (i < this.mappingTable.getItemCount()) {
            block10: {
                boolean validProject;
                String projectName;
                block9: {
                    boolean projectExist;
                    block8: {
                        TableItem itemToEdit = this.mappingTable.getItem(i);
                        projectName = itemToEdit.getText(1);
                        if (!this.projectExistanceMap.containsKey(projectName)) break block8;
                        projectExist = this.projectExistanceMap.get(projectName);
                        if (projectExist) break block9;
                        break block10;
                    }
                    projectExist = PlatformUtil.isProjectExist((String)projectName);
                    this.projectExistanceMap.put(projectName, new Boolean(projectExist));
                    if (!projectExist) break block10;
                }
                if (this.validProjectMap.containsKey(projectName)) {
                    validProject = this.validProjectMap.get(projectName);
                    if (!validProject) {
                        return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_XSDLIB_PROJECT_INVALID, (Object[])new String[]{projectName}));
                    }
                } else {
                    validProject = this.isValidProject(projectName);
                    this.validProjectMap.put(projectName, new Boolean(validProject));
                    if (!validProject) {
                        return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_XSDLIB_PROJECT_INVALID, (Object[])new String[]{projectName}));
                    }
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private boolean isValidProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (J2EEUtil.isJavaUtilityProject((IProject)project) || J2EEUtil.isEJBProject((IProject)project) || J2EEUtil.isAppClientProject((IProject)project) || J2EEUtil.isJavaConnectorProject((IProject)project)) {
            return true;
        }
        return !J2EEUtil.isWebProject((IProject)project) && !J2EEUtil.isEARProject((IProject)project);
    }

    private IStatus validateProjectsExistance() {
        if (this.earCombo != null && this.earCombo.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_EAR_PROJECT_NOT_FOUND, (Object[])new String[0]));
        }
        if (this.uriToProjectMap != null && this.uriToProjectMap.size() != 0) {
            HashSet<String> existProjects = new HashSet<String>();
            int i = 0;
            while (i < this.mappingTable.getItemCount()) {
                boolean projectExist;
                TableItem itemToEdit = this.mappingTable.getItem(i);
                String projectName = itemToEdit.getText(1);
                if (this.projectExistanceMap.containsKey(projectName)) {
                    projectExist = this.projectExistanceMap.get(projectName);
                    if (projectExist) {
                        existProjects.add(projectName);
                    }
                } else {
                    projectExist = PlatformUtil.isProjectExist((String)projectName);
                    this.projectExistanceMap.put(projectName, new Boolean(projectExist));
                    if (projectExist) {
                        existProjects.add(projectName);
                    }
                }
                ++i;
            }
            if (existProjects.size() == 0) {
                return Status.OK_STATUS;
            }
            StringBuffer sb = new StringBuffer();
            for (String project : existProjects) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(project);
            }
            if (existProjects.size() == 1) {
                return StatusUtils.warningStatus((String)Messages.bind((String)Messages.MSG_WARN_PROJECT_EXIST, (Object[])new String[]{sb.toString()}));
            }
            if (existProjects.size() > 1) {
                return StatusUtils.warningStatus((String)Messages.bind((String)Messages.MSG_WARN_PROJECTS_EXIST, (Object[])new String[]{sb.toString()}));
            }
        }
        return Status.OK_STATUS;
    }

    private void populateEarCombo() {
        if (this.createEAR && this.earCombo != null) {
            IProject[] earProjects;
            this.earCombo.removeAll();
            IProject[] iProjectArray = earProjects = J2EEUtil.getAllEARProjects();
            int n = earProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject earProject = iProjectArray[n2];
                this.earCombo.add(earProject.getName());
                ++n2;
            }
            if (this.earCombo.getItemCount() > 0) {
                this.earCombo.select(0);
            }
        }
    }

    private void updateDuplicateProject(String oldProjectName, String newProjectName) {
        TableItem[] tableItemArray = this.mappingTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem itemToEdit = tableItemArray[n2];
            if (itemToEdit.getText(1) != null && itemToEdit.getText(1).equals(oldProjectName)) {
                itemToEdit.setText(new String[]{itemToEdit.getText(0), newProjectName});
            }
            ++n2;
        }
    }

    private void handleRestore() {
        for (String xsdUri : this.uriToProjectMap.keySet()) {
            TableItem itemToEdit = new TableItem(this.mappingTable, 8);
            itemToEdit.setText(new String[]{xsdUri, this.uriToProjectMap.get(xsdUri)});
        }
        if (this.mappingTable.getItemCount() > 0) {
            this.mappingTable.select(0);
        }
    }

    public HashMap<String, String> getUriToProjectMap() {
        HashMap<String, String> table = new HashMap<String, String>();
        int i = 0;
        while (i < this.mappingTable.getItemCount()) {
            TableItem itemToEdit = this.mappingTable.getItem(i);
            table.put(itemToEdit.getText(0), itemToEdit.getText(1));
            ++i;
        }
        return table;
    }

    public void setUriToProjectMap(HashMap<String, String> uriToProjectMap) {
        this.uriToProjectMap = uriToProjectMap;
        if (uriToProjectMap == null || uriToProjectMap.size() == 0) {
            this.enableFields = false;
        }
        this.mappingTable.removeAll();
        this.handleRestore();
        if (this.earCombo != null) {
            this.earCombo.setEnabled(this.enableFields);
        }
        this.mappingTable.setEnabled(this.enableFields);
        this.editButton.setEnabled(this.enableFields);
        this.restoreDefaultButton.setEnabled(this.enableFields);
    }

    public boolean getCreateEAR() {
        return this.createEAR;
    }

    public String getEarProjectName() {
        if (!this.createEAR || this.earCombo == null || this.earCombo.getText().trim().length() == 0) {
            return null;
        }
        return this.earCombo.getText().trim();
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }
}

