/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.widgets;

import com.ibm.ast.ws.jaxb.ui.command.Timer;
import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SchemaSelectionWidget
extends SimpleWidgetDataContributor
implements Runnable {
    private Listener statusListener;
    protected boolean resourceSelected = false;
    protected IFile file;
    protected TreeViewer fileViewer;
    private String INFOPOP_JAXB_URL_BUTTON = "JAXB0006";
    protected Button urlSchema;
    private String INFOPOP_JAXB_FILE_BUTTON = "JAXB0007";
    protected Button workspaceSchema;
    private String INFOPOP_JAXB_URL_TEXT = "JAXB0008";
    protected Text urlText;
    private String INFOPOP_JAXB_FILE_TREE = "JAXB0009";
    protected Tree tree;
    protected URI schemaURI;
    private Timer timer_ = null;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxb.ui");
        this.urlSchema = uiUtils.createRadioButton(parent, Messages.BUTTON_URL_SCHEMA, Messages.TOOLTIP_JAXB_URL_BUTTON, this.INFOPOP_JAXB_URL_BUTTON);
        Composite urlComposite = uiUtils.createComposite(parent, 2);
        this.urlText = uiUtils.createText(urlComposite, Messages.LABEL_URL_SCHEMA, Messages.TOOLTIP_JAXB_URL_TEXT, this.INFOPOP_JAXB_URL_TEXT, 2112);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaSelectionWidget.this.handleSchemaURIModifyEvent();
            }
        });
        this.workspaceSchema = uiUtils.createRadioButton(parent, Messages.BUTTON_WORKSPACE_SCHEMA, Messages.TOOLTIP_JAXB_FILE_BUTTON, this.INFOPOP_JAXB_FILE_BUTTON);
        this.tree = uiUtils.createTree(parent, Messages.TOOLTIP_JAXB_FILE_TREE, this.INFOPOP_JAXB_FILE_TREE, 2048);
        this.fileViewer = new TreeViewer(this.tree);
        this.fileViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SchemaSelectionWidget.this.handleEvent(null);
            }
        });
        this.fileViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.fileViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object object) {
                return !(object instanceof IFile) || ((IFile)object).getName().endsWith(".xsd");
            }
        });
        this.urlSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaSelectionWidget.this.enableControls();
            }
        });
        this.workspaceSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaSelectionWidget.this.enableControls();
            }
        });
        return this;
    }

    private void handleSchemaURIModifyEvent() {
        if (this.urlText.getText().indexOf(58) > 0) {
            this.timer_ = Timer.newInstance(this.timer_, Display.getCurrent(), this);
            this.timer_.startTimer();
        } else {
            this.handleEvent(null);
        }
    }

    private void enableControls() {
        boolean wsSchema = this.workspaceSchema.getSelection();
        this.urlText.setEnabled(!wsSchema);
        this.tree.setEnabled(wsSchema);
        this.handleEvent(null);
    }

    public IStatus getStatus() {
        if (this.urlSchema.getSelection()) {
            this.urlText.setFocus();
            String url = this.urlText.getText().trim();
            if (url.length() == 0) {
                this.schemaURI = null;
                return StatusUtils.errorStatus((String)Messages.ERROR_URL_SCHEMA);
            }
            return this.validateSchema(url);
        }
        IResource resource = (IResource)((IStructuredSelection)this.fileViewer.getSelection()).getFirstElement();
        if (resource instanceof IFile) {
            if (this.file != resource) {
                this.file = (IFile)resource;
            }
            return Status.OK_STATUS;
        }
        return StatusUtils.errorStatus((String)Messages.ERROR_SELECT_SCHEMA);
    }

    private IStatus validateSchema(String url) {
        try {
            File file;
            URL myURL = new URL(url);
            if (myURL.getProtocol().equals("http") && myURL.openConnection() != null && myURL.getContent() != null) {
                this.schemaURI = myURL.toURI();
                return Status.OK_STATUS;
            }
            if (myURL.getProtocol().equals("file") && !myURL.getFile().equals("") && (file = new File(myURL.getFile())).isFile()) {
                this.schemaURI = myURL.toURI();
                return Status.OK_STATUS;
            }
            this.schemaURI = null;
            return StatusUtils.errorStatus((String)Messages.ERROR_INVALID_SCHEMA);
        }
        catch (Exception exception) {
            this.schemaURI = null;
            return StatusUtils.errorStatus((String)Messages.ERROR_INVALID_SCHEMA);
        }
    }

    public void handleEvent(Event event) {
        this.statusListener.handleEvent(event);
    }

    public IFile getSchemaFile() {
        return this.urlSchema.getSelection() ? null : this.file;
    }

    public URI getSchemaFileURI() {
        if (this.urlSchema.getSelection()) {
            return this.schemaURI;
        }
        return this.file.getLocationURI();
    }

    public void setInitialSelection(IResource resource) {
        if (this.resourceSelected) {
            return;
        }
        this.resourceSelected = true;
        if (resource != null) {
            this.fileViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
            this.workspaceSchema.setSelection(true);
        } else {
            this.urlSchema.setSelection(true);
        }
        this.enableControls();
    }

    @Override
    public void run() {
        this.handleEvent(null);
    }
}

