/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.command;

import com.ibm.ast.ws.jaxws.emitter.common.MappingObject;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ExecuteXJCCommand
extends AbstractDataModelOperation {
    protected MappingObject mapping;

    public ExecuteXJCCommand() {
        this.mapping = new MappingObject();
    }

    public ExecuteXJCCommand(MappingObject mapping) {
        this.mapping = mapping;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        int i;
        File outputDir = PlatformUtil.createTempDir();
        this.mapping.setOutputSrcLocation(outputDir.getAbsolutePath());
        Vector<String> args = new Vector<String>();
        args.add("-d");
        args.add(this.mapping.getOutputSrcLocation());
        if (this.mapping.getJavaPackage() != null) {
            args.add("-p");
            args.add(this.mapping.getJavaPackage());
        }
        if (this.mapping.getBindingFiles() != null && this.mapping.getBindingFiles().size() > 0) {
            i = 0;
            while (i < this.mapping.getBindingFiles().size()) {
                args.add("-b");
                args.add((String)this.mapping.getBindingFiles().get(i));
                ++i;
            }
        }
        args.add(this.mapping.getSchemaURI().toString());
        this.mapping.setArgs(new String[args.size()]);
        i = 0;
        while (i < args.size()) {
            this.mapping.getArgs()[i] = (String)args.get(i);
            ++i;
        }
        return Status.OK_STATUS;
    }

    public void setBindingFiles(List<String> bindingFiles) {
        this.mapping.setBindingFiles(bindingFiles);
    }

    public void setSchemaFileURI(URI file) {
        this.mapping.setSchemaURI(file);
    }

    public void setJavaPackage(String javaPackage) {
        this.mapping.setJavaPackage(javaPackage);
    }

    public String getOutputSrcLocation() {
        return this.mapping.getOutputSrcLocation();
    }

    public String[] getArgs() {
        return this.mapping.getArgs();
    }
}

