/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.command;

import com.ibm.ast.ws.jaxb.ui.command.CopyGeneratedFilesCommand;
import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.common.MappingObject;
import com.ibm.ast.ws.jaxws.xsd.XSDModel;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IStatusHandler;

public class CopyJavaFilesToXSDProjectsCommand
extends CopyGeneratedFilesCommand {
    protected HashMap<String, String> classToXSDMap;
    protected HashMap<String, IPath> projectToOutputPathMap;
    protected HashMap<String, String> uriToProjectMap;

    public CopyJavaFilesToXSDProjectsCommand() {
        super(Messages.MSG_PROGRESS_CREATE_SCHEMA_PROJECTS);
    }

    public CopyJavaFilesToXSDProjectsCommand(MappingObject mapping) {
        super(mapping, Messages.MSG_PROGRESS_CREATE_SCHEMA_PROJECTS);
    }

    @Override
    protected boolean needToCopyFileWhenGenXSDProjects() {
        if (this.genXSDProjects) {
            XSDModel xsdModel;
            if (this.mapping != null && (xsdModel = this.mapping.getXsdModel()) != null) {
                this.classToXSDMap = xsdModel.getClassToXSDMap();
                this.uriToProjectMap = xsdModel.getUriToProjectMap();
                this.projectToOutputPathMap = xsdModel.getProjectToOutputPathMap();
            }
            return true;
        }
        return false;
    }

    @Override
    protected IStatus processGeneratedFiles(File directory, int tempDirPrefixPos, IProgressMonitor monitor, IStatusHandler handler) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                IStatus retStatus = this.processGeneratedFiles(files[i], tempDirPrefixPos, monitor, handler);
                if (retStatus.getSeverity() != 0) {
                    return retStatus;
                }
            } else {
                IStatus retStatus;
                String projectName;
                String className;
                String xsdName;
                String filePath = files[i].getAbsolutePath();
                String curFile = filePath.substring(this.outputSrcLocation.length());
                IPath targetFilePath = this.outputPath.append(curFile);
                IPath tmpPath = null;
                if (this.classToXSDMap != null && this.uriToProjectMap != null && this.projectToOutputPathMap != null && (xsdName = this.classToXSDMap.get(className = this.getClassName(curFile))) != null && (projectName = this.uriToProjectMap.get(xsdName)) != null) {
                    tmpPath = this.projectToOutputPathMap.get(projectName);
                }
                if (tmpPath != null) {
                    targetFilePath = tmpPath.append(curFile);
                }
                if ((retStatus = this.overwriteResource(files[i], targetFilePath, monitor, handler)).getSeverity() != 0) {
                    return retStatus;
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public void setClassToXSDMap(HashMap<String, String> classToXSDMap) {
        this.classToXSDMap = classToXSDMap;
    }

    public void setProjectToOutputPathMap(HashMap<String, IPath> projectToOutputPathMap) {
        this.projectToOutputPathMap = projectToOutputPathMap;
    }

    public void setUriToProjectMap(HashMap<String, String> uriToProjectMap) {
        this.uriToProjectMap = uriToProjectMap;
    }
}

