/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.command;

import com.ibm.ast.ws.jaxb.ui.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.common.MappingObject;
import com.ibm.ast.ws.jaxws.emitter.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.ChainedJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CopyGeneratedFilesCommand
extends AbstractDataModelOperation {
    protected ResourceContext resCtx_;
    protected IPath outputPath;
    protected String outputSrcLocation;
    protected String targetPath;
    protected File sourceDir;
    protected IEnvironment env;
    protected ArrayList<IResource> genFileList = new ArrayList();
    protected MappingObject mapping;
    protected IFile docFile = null;
    protected static final String PACKAGE_DOC_FILE = "package.html";
    protected boolean genXSDProjects = false;
    private String operationName;

    public CopyGeneratedFilesCommand(String operationName) {
        this(new MappingObject(), operationName);
    }

    public void setShouldWaitFor(ChainedJob waitFor) {
        this.mapping.setXJCJob(waitFor);
    }

    public CopyGeneratedFilesCommand(MappingObject mapping, String operationName) {
        this.mapping = mapping;
        this.operationName = operationName;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.needToCopyFileWhenGenXSDProjects()) {
            return Status.OK_STATUS;
        }
        if (this.outputSrcLocation == null) {
            this.outputSrcLocation = this.mapping.getOutputSrcLocation();
        }
        if (this.outputSrcLocation == null || this.outputSrcLocation.length() == 0) {
            return Status.OK_STATUS;
        }
        this.env = super.getEnvironment();
        this.resCtx_ = this.getResourceContext(this.env);
        this.outputPath = ResourcesPlugin.getWorkspace().getRoot().findMember(this.targetPath).getFullPath();
        this.sourceDir = new File(this.outputSrcLocation);
        Job copyJob = new Job(this.operationName){

            public boolean belongsTo(Object family) {
                return "com.ibm.ast.ws.jaxb.ui".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CopyFileOperation copyOp = new CopyFileOperation(CopyGeneratedFilesCommand.this.sourceDir, CopyGeneratedFilesCommand.this.env.getStatusHandler());
                    ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copyOp, monitor);
                    IStatus status = copyOp.getStatus();
                    if (status.getSeverity() == 0 && CopyGeneratedFilesCommand.this.docFile != null) {
                        CopyGeneratedFilesCommand.this.viewPackageHTML(CopyGeneratedFilesCommand.this.docFile);
                    }
                    return status;
                }
                catch (Throwable t) {
                    return StatusUtils.errorStatus((String)Messages.MSG_ERROR_XJC, (Throwable)t);
                }
            }
        };
        if (this.mapping.getXJCJob() == null) {
            copyJob.schedule();
        } else {
            this.mapping.getXJCJob().setNextJob(copyJob);
        }
        return Status.OK_STATUS;
    }

    protected boolean needToCopyFileWhenGenXSDProjects() {
        return !this.genXSDProjects;
    }

    protected final ResourceContext getResourceContext(IEnvironment env) {
        return ((BaseEclipseEnvironment)env).getResourceContext();
    }

    protected IStatus overwriteResource(File tempFile, IPath tmpPath, IProgressMonitor monitor, IStatusHandler handler) {
        try {
            FileInputStream fis = new FileInputStream(tempFile);
            IFile javaFile = FileResourceUtils.createFile((ResourceContext)this.resCtx_, (IPath)tmpPath, (InputStream)fis, (IProgressMonitor)monitor, (IStatusHandler)handler);
            fis.close();
            if (javaFile == null) {
                return StatusUtils.errorStatus((String)"");
            }
            if (javaFile.getName().equals(PACKAGE_DOC_FILE)) {
                this.docFile = javaFile;
            }
            this.genFileList.add((IResource)javaFile);
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    protected IStatus processGeneratedFiles(File directory, int tempDirPrefixPos, IProgressMonitor monitor, IStatusHandler handler) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                IStatus retStatus = this.processGeneratedFiles(files[i], tempDirPrefixPos, monitor, handler);
                if (retStatus.getSeverity() != 0) {
                    return retStatus;
                }
            } else {
                String filePath = files[i].getAbsolutePath();
                String curFile = filePath.substring(this.outputSrcLocation.length());
                IPath targetFilePath = this.outputPath.append(curFile);
                IStatus retStatus = this.overwriteResource(files[i], targetFilePath, monitor, handler);
                if (retStatus.getSeverity() != 0) {
                    return retStatus;
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private void viewPackageHTML(IFile file) {
        LaunchBrowserRunnable runnable = new LaunchBrowserRunnable(file);
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)runnable);
    }

    protected String getClassName(String fileName) {
        String className = fileName;
        if (fileName.startsWith(File.separator)) {
            className = fileName.substring(1);
        }
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        className = className.replace(File.separatorChar, '.');
        return className;
    }

    public void setOutputSrcLocation(String outputSrcLocation) {
        this.outputSrcLocation = outputSrcLocation;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public IPath getOutputPath() {
        return this.outputPath;
    }

    public ArrayList<IResource> getGenFileList() {
        return this.genFileList;
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.genXSDProjects = genXSDProjects;
    }

    protected final class CopyFileOperation
    implements IWorkspaceRunnable {
        private File rootDir;
        private IStatusHandler handler;
        private IStatus status;

        CopyFileOperation(File dir, IStatusHandler hdler) {
            this.rootDir = dir;
            this.handler = hdler;
        }

        public void run(IProgressMonitor monitor) {
            this.status = CopyGeneratedFilesCommand.this.processGeneratedFiles(this.rootDir, CopyGeneratedFilesCommand.this.outputSrcLocation.length() + 1, monitor, this.handler);
            try {
                ResourcesPlugin.getWorkspace().build(10, monitor);
            }
            catch (CoreException coreException) {}
        }

        public IStatus getStatus() {
            return this.status;
        }
    }

    private class LaunchBrowserRunnable
    implements Runnable {
        private IFile file;

        public LaunchBrowserRunnable(IFile file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                IWorkbenchBrowserSupport browserSupport = Activator.getDefault().getWorkbench().getBrowserSupport();
                IWebBrowser browser = browserSupport.createBrowser(2, null, CopyGeneratedFilesCommand.PACKAGE_DOC_FILE, null);
                browser.openURL(this.file.getLocationURI().toURL());
            }
            catch (Exception exception) {}
        }
    }
}

