/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.command;

import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxb.ui.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.common.MappingObject;
import com.ibm.ast.ws.jaxws.emitter.plugin.JaxWSEmitterPlugin;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class AddCPVariableOrFacetsToProjectCommand
extends AbstractDataModelOperation {
    private MappingObject mappingObject;

    public AddCPVariableOrFacetsToProjectCommand() {
        this(new MappingObject());
        this.mappingObject.setGenXsd(false);
    }

    public AddCPVariableOrFacetsToProjectCommand(MappingObject mappingObject) {
        this.mappingObject = mappingObject;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block11: {
            IFacetedProject facetProj = null;
            IProject clientProject = this.mappingObject.getProject();
            if (clientProject != null && clientProject.exists()) {
                try {
                    facetProj = ProjectFacetsManager.create((IProject)clientProject);
                    if (facetProj == null || JavaUtil.isUnmanagedProject((IProject)clientProject)) {
                        return this.addClassPathToProject(monitor);
                    }
                    try {
                        IRuntimeType runtimeType = FacetUtil.getRuntime((IRuntime)facetProj.getPrimaryRuntime()).getRuntimeType();
                        if (WASRuntimeUtil.isWASv61RuntimeType((IRuntimeType)runtimeType)) {
                            String facetConstant = "com.ibm.websphere.wsfp.web";
                            if (J2EEUtil.isEJBProject((IProject)clientProject)) {
                                facetConstant = "com.ibm.websphere.wsfp.ejb";
                            }
                            if (J2EEUtil.isAppClientProject((IProject)clientProject)) {
                                facetConstant = "com.ibm.websphere.wsfp.appclient";
                            }
                            if (J2EEUtil.isJavaUtilityProject((IProject)clientProject)) {
                                facetConstant = "com.ibm.websphere.wsfp.utility";
                            }
                            HashSet<IProjectFacetVersion> facetsToAddModified = new HashSet<IProjectFacetVersion>();
                            IProjectFacetVersion wsfpFacetVersion = ProjectFacetsManager.getProjectFacet((String)facetConstant).getVersion("1.0");
                            if (!facetProj.hasProjectFacet(wsfpFacetVersion)) {
                                facetsToAddModified.add(wsfpFacetVersion);
                                FacetUtils.addFacetsToProject((IFacetedProject)facetProj, facetsToAddModified);
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                catch (Exception ce) {
                    if (!this.isTraceMode()) break block11;
                    Activator.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)ce));
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus addClassPathToProject(IProgressMonitor monitor) throws CoreException {
        String serverFactoryId = this.mappingObject.getServerFactoryId();
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        String variableName = null;
        if (serverType != null) {
            IRuntimeType runtimeType = serverType.getRuntimeType();
            if (WASRuntimeUtil.isWASv61RuntimeType((IRuntimeType)runtimeType)) {
                if (!JaxWSEmitterPlugin.getInstance().isV61WsfpThinClientClasspathSet()) {
                    JaxWSEmitterPlugin.getInstance().setUpV61WsfpClassPathVariable();
                }
                variableName = "WAS_V61FP_WEBSERVICES_THINCLIENT";
            } else if (WASRuntimeUtil.isWASv70RuntimeType((IRuntimeType)runtimeType)) {
                if (!JaxWSEmitterPlugin.getInstance().isV7ThinClientClasspathSet()) {
                    JaxWSEmitterPlugin.getInstance().setUpV7ClassPathVariable();
                }
                variableName = "WAS_V7JAXWS_WEBSERVICES_THINCLIENT";
            }
        } else {
            return StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_SERVETYPE_NOT_FOUND, (Object)serverFactoryId));
        }
        if (variableName == null) {
            return StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_THINCLIENT_VAR_NOT_FOUND, (Object)serverFactoryId));
        }
        IProject clientProject = this.mappingObject.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)clientProject);
        IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
        Path desiredPath = new Path(variableName);
        int i = 0;
        while (i < classPathEntries.length) {
            IPath path;
            IClasspathEntry classpathEntry = classPathEntries[i];
            if (classpathEntry.getEntryKind() == 4 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                if (this.isTraceMode()) {
                    Activator.getDefault().getLog().log(StatusUtils.infoStatus((String)("found path " + classpathEntry.getPath() + "in project " + clientProject.getName())));
                }
                return Status.OK_STATUS;
            }
            ++i;
        }
        IClasspathEntry thinClientClassPathEntry = JavaCore.newVariableEntry((IPath)desiredPath, null, null);
        IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + 1];
        newClassPathEntries[0] = thinClientClassPathEntry;
        int i2 = 0;
        while (i2 < classPathEntries.length) {
            newClassPathEntries[i2 + 1] = classPathEntries[i2];
            ++i2;
        }
        javaProject.setRawClasspath(newClassPathEntries, monitor);
        return Status.OK_STATUS;
    }

    private boolean isTraceMode() {
        return Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.ibm.ast.ws.jaxb.ui/debug"));
    }

    public void setProject(IProject clientProject) {
        this.mappingObject.setProject(clientProject);
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.mappingObject.setServerFactoryId(serverFactoryId);
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.mappingObject.setGenXsd(genXSDProjects);
    }
}

