/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.wsrt.checker;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.environment.resource.ResourceUtils;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.ws.internal.wsrt.AbstractWebServiceRuntimeChecker;

public class EJB3ProjectChecker
extends AbstractWebServiceRuntimeChecker {
    public IStatus checkRuntimeCompatibility(String serverTypeId, String serverInstanceId, String projectName, String projectTypeId, String earProjectName) {
        try {
            IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectName);
            if (!project.exists()) {
                return Status.OK_STATUS;
            }
            if (!J2EEUtils.isEJBProject((IProject)project)) {
                return Status.OK_STATUS;
            }
            String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
            if (!"3.0".equals(version)) {
                return Status.OK_STATUS;
            }
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            Set projFacets = fProject.getProjectFacets();
            for (IProjectFacetVersion facetVersion : projFacets) {
                if (!facetVersion.getProjectFacet().getId().equals("com.ibm.websphere.extended.ejb")) continue;
                if (facetVersion.getVersionString().equals("6.1")) {
                    return StatusUtils.errorStatus((String)Messages.EJB_3_NOT_SUPPORTED_WAS61);
                }
                return Status.OK_STATUS;
            }
            if (serverTypeId.startsWith("com.ibm.ws.ast.st.v61")) {
                return StatusUtils.errorStatus((String)Messages.EJB_3_NOT_SUPPORTED_WAS61);
            }
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }
}

