/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.utils.BuildWSDLPort2ImplBeanMappingTask;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.was.utils.WSDLCopierUtil;
import java.util.Hashtable;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.w3c.dom.Element;

public class Skeleton2WSDLTask
extends AbstractDataModelOperation {
    private final String IMPL = "Impl";
    private final String SERVICE_EXT = "services/";
    private final String DOT = ".";
    private final String WSDL_FOLDER = "wsdl";
    private final String NAME_COLLISION_PORT = "_Port";
    private final String SUFFIX_HOME = "Home";
    private JavaWSDLParameterBase javaWSDLParam_ = null;
    private String eJBProjectName;
    private IProject serviceProject;
    private WebServicesParser wSParser;
    private String wSDLServicePathname;
    private String wSDLServiceURL;
    private AbstractEmitterCommand wsdl2JavaCommand_;
    private Hashtable namespaceToPackageMapping;
    private Hashtable portTypeToSEIMapping;
    private String serverInstanceId;
    private String guessWebProjectURL;
    private String routerProjectName;
    private String host = "http://localhost:9080/";
    private String wsdlRelativePath;
    private String originalWSDLDestination;

    public Skeleton2WSDLTask() {
    }

    public Skeleton2WSDLTask(JavaWSDLParameterBase javaWSDLParam) {
        this();
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        boolean isEJB = this.javaWSDLParam_.getServerSide() == 2;
        IProject project = isEJB ? ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName) : this.serviceProject;
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam_.getInputWsdlLocation();
        if (wsdlURL.indexOf(58) < 0 || wsdlURL.indexOf("platform:/resource") >= 0) {
            wsdlURL = PlatformUtils.getFileURLFromPlatform(wsdlURL);
        }
        definition = this.wSParser.getWSDLDefinition(wsdlURL);
        BuildWSDLPort2ImplBeanMappingTask t = new BuildWSDLPort2ImplBeanMappingTask();
        t.setJavaWSDLParam(this.javaWSDLParam_);
        t.setWsdl2JavaCommand(this.wsdl2JavaCommand_);
        t.setTopDown(true);
        t.setWSParser(this.wSParser);
        t.setNamespaceToPackageMapping(this.namespaceToPackageMapping);
        t.setPortTypeToSEIMapping(this.portTypeToSEIMapping);
        t.setEnvironment(env);
        IStatus status = t.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        String wsdlLocation = null;
        Service service = null;
        Port port = null;
        if (definition == null) {
            status = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WSDL_NO_DEFINITION, (Object[])new String[]{wsdlURL}));
            env.getStatusHandler().reportError(status);
            return status;
        }
        StringBuffer beanName = new StringBuffer();
        beanName.append(WSDLUtils.getPackageNameForBindingImpl(definition, (Map)this.javaWSDLParam_.getMappings()));
        beanName.append(".");
        service = (Service)definition.getServices().values().iterator().next();
        port = (Port)service.getPorts().values().iterator().next();
        Binding binding = port.getBinding();
        String tmpBeanName = String.valueOf(binding.getQName().getLocalPart().substring(0, 1).toUpperCase()) + binding.getQName().getLocalPart().substring(1);
        beanName.append(WSDLUtils.resolveDotInPortName(tmpBeanName));
        beanName.append("Impl");
        this.javaWSDLParam_.setBeanName(beanName.toString());
        this.javaWSDLParam_.setPortTypeName(WSDLUtils.getPortTypeName(definition));
        this.javaWSDLParam_.setServiceName(WSDLUtils.getServiceElementName(definition));
        this.javaWSDLParam_.setBeanPackage(WSDLUtils.getPackageNameForPortType(definition));
        String jmsLocation = this.javaWSDLParam_.getJmsLocation();
        String projectURL = null;
        String webModule = this.serviceProject.getName();
        webModule = isEJB ? J2EEUtils.getServerContextRoot((String)this.routerProjectName) : J2EEUtils.getServerContextRoot((IProject)this.serviceProject);
        try {
            if (this.serviceProject != null && this.serviceProject.exists() && webModule != null) {
                IServer server = null;
                if (this.serverInstanceId != null) {
                    server = ServerCore.findServer((String)this.serverInstanceId);
                }
                if (server != null) {
                    int serverState = server.getServerState();
                    if (serverState != 4) {
                        projectURL = ServerUtils.getWebComponentURL((IProject)this.serviceProject, null, (IServer)server);
                    }
                } else {
                    projectURL = ServerUtils.getEncodedWebComponentURL((IProject)this.serviceProject, null);
                }
            }
            if (projectURL == null && webModule != null) {
                this.guessWebProjectURL = projectURL = String.valueOf(this.host) + webModule + "/";
            } else if (projectURL != null) {
                this.guessWebProjectURL = null;
            }
        }
        catch (Exception exception) {
            this.guessWebProjectURL = projectURL = String.valueOf(this.host) + webModule + "/";
        }
        boolean isURLLocationSet = false;
        Map services = definition.getServices();
        for (Service ser : services.values()) {
            Map ports = ser.getPorts();
            block5: for (Port p : ports.values()) {
                for (Object obj : p.getExtensibilityElements()) {
                    if (obj instanceof SOAPAddress) {
                        SOAPAddress soapAddress = (SOAPAddress)obj;
                        StringBuffer serviceURL = new StringBuffer();
                        if (jmsLocation != null && soapAddress.getLocationURI() != null && soapAddress.getLocationURI().startsWith("jms:") && !this.javaWSDLParam_.getSwitchBinding() || jmsLocation != null && this.javaWSDLParam_.getBindingTypes() != null && this.javaWSDLParam_.getBindingTypes().indexOf("http") != -1 && this.javaWSDLParam_.getSwitchBinding()) {
                            serviceURL.append(jmsLocation);
                            serviceURL.append("&targetService=");
                            serviceURL.append(port.getName());
                        } else {
                            serviceURL.append(projectURL);
                            if (!projectURL.endsWith("/")) {
                                serviceURL.append("/");
                            }
                            serviceURL.append("services/");
                            serviceURL.append(p.getName());
                        }
                        soapAddress.setLocationURI(serviceURL.toString());
                        if (isURLLocationSet) continue block5;
                        this.javaWSDLParam_.setUrlLocation(serviceURL.toString());
                        isURLLocationSet = true;
                        continue block5;
                    }
                    if (!(obj instanceof UnknownExtensibilityElement)) continue;
                    Element ele = ((UnknownExtensibilityElement)obj).getElement();
                    if (this.javaWSDLParam_.getBindingTypes() == null || this.javaWSDLParam_.getBindingTypes().indexOf("ejb") == -1 || ele == null || ele.getAttribute("location") == null || !ele.getAttribute("location").startsWith("wsejb:")) continue;
                    ele.setAttribute("location", this.computeEJBBindingAddress(ser, port));
                }
            }
        }
        IPath wsdlPath = project.getFullPath();
        try {
            IVirtualFolder ivFolder;
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (J2EEUtils.isWebProject((IProject)project)) {
                ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
            } else if (J2EEUtils.isEJBProject((IProject)project)) {
                ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
            }
            IPath tmpPath = wsdlPath.append("wsdl");
            wsdlPath = wsdlPath.append("wsdl").append(WSDLUtils.getWSDLName(wsdlURL));
            wsdlLocation = PlatformUtils.getPlatformURL(wsdlPath);
            this.javaWSDLParam_.setOutputWsdlLocation(wsdlLocation);
            this.wSDLServicePathname = wsdlPath.toString();
            if (wsdlPath != null) {
                this.wSDLServiceURL = PlatformUtils.getPlatformFromPath(wsdlPath.toString());
            }
            this.wsdlRelativePath = null;
            WSDLCopier wsdlCopier = new WSDLCopier(this.wSParser);
            wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)wsdlURL), definition);
            wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.wSDLServiceURL)));
            wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.wSDLServiceURL));
            status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            this.originalWSDLDestination = this.wSDLServiceURL;
            IPath relativePath = wsdlCopier.getRelativePath();
            if (relativePath.segmentCount() > 1) {
                String infDir = "WEB-INF";
                if (isEJB) {
                    infDir = "META-INF";
                }
                IPath fullRelativePath = new Path(infDir).append("wsdl").append(relativePath);
                this.wsdlRelativePath = fullRelativePath.toString();
                tmpPath = tmpPath.append(relativePath);
                wsdlLocation = PlatformUtils.getPlatformURL(tmpPath);
                this.javaWSDLParam_.setOutputWsdlLocation(wsdlLocation);
                this.wSDLServicePathname = tmpPath.toString();
                if (tmpPath != null) {
                    this.wSDLServiceURL = PlatformUtils.getPlatformFromPath(tmpPath.toString());
                }
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WRITE_WSDL, (Object[])new String[]{wsdlLocation}), (Throwable)e);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private String computeEJBBindingAddress(Service service, Port port) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("wsejb:/");
        PortType portType = port.getBinding().getPortType();
        String portTypeName = portType.getQName().getLocalPart();
        portTypeName = String.valueOf(portTypeName.substring(0, 1).toUpperCase()) + portTypeName.substring(1);
        String ejbPackage = this.getPackageName(portType.getQName().getNamespaceURI());
        if (ejbPackage == null) {
            ejbPackage = WSDLUtils.getPackageName(portType, (Map)this.namespaceToPackageMapping);
        }
        StringBuffer ejbInterfaceName = new StringBuffer(WSDLUtils.resolveDotInPortName(portTypeName));
        if (service != null && ejbInterfaceName.toString().equals(service.getQName().getLocalPart())) {
            String servicePackage = this.getPackageName(service.getQName().getNamespaceURI());
            if (servicePackage == null) {
                servicePackage = WSDLUtils.getPackageName(service, (Map)this.namespaceToPackageMapping);
            }
            if (ejbPackage.equals(servicePackage)) {
                if (this.javaWSDLParam_.getJ2eeLevel().equals("1.3")) {
                    ejbInterfaceName.append("_Port");
                } else {
                    ejbInterfaceName.append("_PortType");
                }
            }
        }
        String ejbHome = new StringBuffer(ejbPackage).append(".").append(ejbInterfaceName).append("Home").toString();
        buffer.append(ejbHome).append("?jndiName=");
        String jndiName = ejbInterfaceName + "Home";
        buffer.append(jndiName);
        return buffer.toString();
    }

    private String getPackageName(String namespace) {
        if (this.namespaceToPackageMapping != null && namespace != null) {
            return (String)this.namespaceToPackageMapping.get(namespace);
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServerProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public String getWSDLServicePathname() {
        return this.wSDLServicePathname;
    }

    public String getWSDLServiceURL() {
        return this.wSDLServiceURL;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public void setWsdl2JavaCommand(AbstractEmitterCommand wsdl2JavaCommand) {
        if (wsdl2JavaCommand instanceof AbstractWSDL2JavaCommand) {
            this.wsdl2JavaCommand_ = wsdl2JavaCommand;
        }
    }

    public void setNamespaceToPackageMapping(Hashtable namespaceToPackageMapping) {
        this.namespaceToPackageMapping = namespaceToPackageMapping;
    }

    public void setRouterProjectName(String routerProjectName) {
        this.routerProjectName = routerProjectName;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public String getGuessWebProjectURL() {
        return this.guessWebProjectURL;
    }

    public void setPortTypeToSEIMapping(Hashtable portTypeToSEIMapping) {
        this.portTypeToSEIMapping = portTypeToSEIMapping;
    }

    public void setHost(String host) {
        if (host != null) {
            StringBuffer sb = new StringBuffer("http://");
            sb.append(host);
            sb.append("/");
            this.host = sb.toString();
        }
    }

    public String getWsdlRelativePath() {
        return this.wsdlRelativePath;
    }

    public String getOriginalWSDLDestination() {
        return this.originalWSDLDestination;
    }
}

