/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.context.TransientResourceContext;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.JaxRPCMapArtifactEdit;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLServiceName;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DeleteSoapBindingImplTask
extends AbstractDataModelOperation {
    private IProject project = null;
    private JavaWSDLParameterBase javaWSDLParam_;

    public DeleteSoapBindingImplTask() {
    }

    public DeleteSoapBindingImplTask(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        if (this.javaWSDLParam_.getSoapBindingImplFile() == null) {
            return Status.OK_STATUS;
        }
        IStatus status = this.deleteFile(this.getSoapBindingImplFileNameFromJaxRpcMapping(this.javaWSDLParam_.getSoapBindingImplFile()));
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaWSDLParam_.getEmitterGeneratedHI() != null && (status = this.deleteFile(this.javaWSDLParam_.getEmitterGeneratedHI())).getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaWSDLParam_.getEmitterGeneratedRI() != null && (status = this.deleteFile(this.javaWSDLParam_.getEmitterGeneratedRI())).getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaWSDLParam_.getEmitterGeneratedSEI() != null && (status = this.deleteFile(this.javaWSDLParam_.getEmitterGeneratedSEI())).getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }

    private IStatus deleteFile(String fileName) {
        Path filePath = new Path(fileName);
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IFile soapBindingImplFile = workspace.getFile((IPath)filePath);
        if (soapBindingImplFile.exists()) {
            TransientResourceContext context = new TransientResourceContext();
            try {
                context.setOverwriteFilesEnabled(true);
                context.setCheckoutFilesEnabled(true);
                soapBindingImplFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_DELETE_SOAP_BINDING_IMPL, (Object[])new String[]{fileName}), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private String getSoapBindingImplFileNameFromJaxRpcMapping(String soapBindingImplFile) {
        block12: {
            JaxRPCMapArtifactEdit jaxrpcArtifactEdit = null;
            try {
                IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
                jaxrpcArtifactEdit = JaxRPCMapArtifactEdit.getJaxRPCMapArtifactEditForRead((IVirtualComponent)component);
                String mappingFileName = this.getJaxRpcMappingFileName(this.javaWSDLParam_.getInputWsdlLocation());
                IVirtualFolder infFolder = this.getInfFolder();
                if (infFolder == null) {
                    String string = soapBindingImplFile;
                    return string;
                }
                IVirtualFile mappingFile = infFolder.getFile(mappingFileName);
                if (mappingFile == null || !mappingFile.exists()) break block12;
                IPath path = this.project.getFullPath();
                path = path.append(mappingFile.getProjectRelativePath());
                String testUri = path.toString();
                JaxrpcmapResource jaxrpcmapRes = jaxrpcArtifactEdit.getJaxRPCMapXmiResource(testUri);
                JavaWSDLMapping j2wMap = jaxrpcmapRes.getJavaWSDLMapping();
                EList mappings = j2wMap.getInterfaceMappings();
                int i = 0;
                while (i < mappings.size()) {
                    if (mappings.get(i) instanceof ServiceInterfaceMapping) {
                        String generatedWSDLServiceName = this.javaWSDLParam_.getServicePortName() == null ? this.javaWSDLParam_.getServiceName() : String.valueOf(this.javaWSDLParam_.getServicePortName()) + "Service";
                        ServiceInterfaceMapping siMap = (ServiceInterfaceMapping)mappings.get(i);
                        WSDLServiceName wsdlServiceName = siMap.getWsdlServiceName();
                        if (wsdlServiceName.getLocalPart().equals(generatedWSDLServiceName)) {
                            String serviceName = wsdlServiceName.getLocalPart();
                            serviceName = serviceName.substring(0, serviceName.lastIndexOf("Service"));
                            String serviceInterface = siMap.getServiceInterface();
                            serviceInterface = serviceInterface.substring(serviceInterface.lastIndexOf(".") + 1);
                            serviceInterface = serviceInterface.substring(0, serviceInterface.lastIndexOf("Service"));
                            String string = soapBindingImplFile.replaceFirst(serviceName, serviceInterface);
                            return string;
                        }
                    }
                    try {
                        ++i;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    break;
                }
            }
            finally {
                if (jaxrpcArtifactEdit != null) {
                    jaxrpcArtifactEdit.dispose();
                }
            }
        }
        return soapBindingImplFile;
    }

    private IVirtualFolder getInfFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isAppClientProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
        } else {
            return null;
        }
        return ivFolder;
    }

    private String getJaxRpcMappingFileName(String uri) {
        String wsdlName = WSDLUtils.getName(uri).trim();
        if (wsdlName.toLowerCase().endsWith(".wsdl")) {
            int lastDot = wsdlName.lastIndexOf(".");
            wsdlName = String.valueOf(wsdlName.substring(0, lastDot)) + "_mapping.xml";
        } else {
            wsdlName = String.valueOf(wsdlName) + "_mapping.xml";
        }
        return wsdlName;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam_) {
        this.javaWSDLParam_ = javaWSDLParam_;
    }
}

