/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.conformance.JAXRPCWebServiceAnalyzer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ValidateObjectSelectionCommand
extends AbstractDataModelOperation {
    private String javaBeanName;
    private IProject serviceProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        block6: {
            IEnvironment env = super.getEnvironment();
            if (this.javaBeanName == null || this.javaBeanName.length() == 0) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_NO_JAVA_BEAN);
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
            if (this.serviceProject == null) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_NO_PROJECT);
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
            try {
                JAXRPCWebServiceAnalyzer analyzer;
                IStatus status;
                IEnvironment environment = this.getEnvironment();
                CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
                if (!context.isJAXRPCValidationEnabled() || (status = (analyzer = new JAXRPCWebServiceAnalyzer()).analyze(this.serviceProject, this.javaBeanName, monitor)).isOK()) break block6;
                try {
                    environment.getStatusHandler().report(status);
                }
                catch (StatusException statusException) {
                    return StatusUtils.errorStatus((String)"");
                }
            }
            catch (Exception exception) {
                IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_CANNOT_LOAD_JAVA_BEAN, (Object[])new String[]{this.javaBeanName, this.serviceProject.getName()}));
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
        }
        return Status.OK_STATUS;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setJavaBeanName(String javaBeanName) {
        this.javaBeanName = javaBeanName;
    }
}

