/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.utils.BuildWSDLPort2ImplBeanMappingTask;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class BackupSoapImplFileCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private WebServicesParser wSParser;
    private AbstractEmitterCommand wsdl2JavaCommand_;
    private boolean backupToTempDir = false;

    public BackupSoapImplFileCommand(boolean backupToTempDir) {
        this.backupToTempDir = backupToTempDir;
    }

    public BackupSoapImplFileCommand() {
    }

    public BackupSoapImplFileCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        if (this.backupToTempDir) {
            return this.backupToTempDir(env, monitor, adaptable);
        }
        if (!WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoBackupSkeletonBean()) {
            return Status.OK_STATUS;
        }
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            env.getStatusHandler().reportError(status);
            return status;
        }
        String javaOutput = this.javaWSDLParam.getDevelopServerJavaOutput();
        if (javaOutput == null) {
            javaOutput = this.javaWSDLParam.getJavaOutput();
        }
        if (javaOutput == null || javaOutput.length() <= 18) {
            return Status.OK_STATUS;
        }
        BuildWSDLPort2ImplBeanMappingTask t = new BuildWSDLPort2ImplBeanMappingTask(this.javaWSDLParam, true);
        t.setJavaWSDLParam(this.javaWSDLParam);
        t.setWsdl2JavaCommand(this.wsdl2JavaCommand_);
        t.setTopDown(true);
        t.setWSParser(this.wSParser);
        t.setEnvironment(env);
        IStatus status = t.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
        for (String implBeanClassName : wsdlPort2ImplBeanMapping.values()) {
            StringBuffer pathName = new StringBuffer(javaOutput.substring(18));
            String implPath = implBeanClassName.replace('.', '/');
            pathName.append("/");
            pathName.append(implPath);
            pathName.append(".java");
            String sourcePathName = pathName.toString();
            String destPathName = pathName.append(".bak").toString();
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            try {
                this.moveIFile(workspace, (IPath)new Path(sourcePathName), (IPath)new Path(destPathName));
            }
            catch (CoreException e) {
                status = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_BAKCUP_SOAP_IMPL_FILE, (Object[])new String[]{sourcePathName}), (Throwable)e);
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus backupToTempDir(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            env.getStatusHandler().reportError(status);
            return status;
        }
        String javaOutput = this.javaWSDLParam.getDevelopServerJavaOutput();
        if (javaOutput == null) {
            javaOutput = this.javaWSDLParam.getJavaOutput();
        }
        if (javaOutput == null || javaOutput.length() <= 18) {
            return Status.OK_STATUS;
        }
        BuildWSDLPort2ImplBeanMappingTask t = new BuildWSDLPort2ImplBeanMappingTask(this.javaWSDLParam, true);
        t.setJavaWSDLParam(this.javaWSDLParam);
        t.setWsdl2JavaCommand(this.wsdl2JavaCommand_);
        t.setTopDown(true);
        t.setWSParser(this.wSParser);
        t.setEnvironment(env);
        IStatus status = t.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        String pluginTempDir = this.getPluginTempDir();
        long curTimestamp = System.currentTimeMillis();
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
        for (String implBeanClassName : wsdlPort2ImplBeanMapping.values()) {
            StringBuffer pathName = new StringBuffer(javaOutput.substring(18));
            String implPath = implBeanClassName.replace('.', '/');
            pathName.append("/");
            pathName.append(implPath);
            pathName.append(".java");
            String sourcePathName = pathName.toString();
            StringBuffer destPathName = new StringBuffer();
            destPathName.append(File.separator).append("ImplBackup").append(curTimestamp);
            destPathName.append(sourcePathName.replace("/", File.separator));
            try {
                IResource sourceRes = this.getResourceForLocation(workspace, (IPath)new Path(sourcePathName));
                if (sourceRes == null || !sourceRes.exists() || !(sourceRes instanceof IFile)) continue;
                InputStream is = ((IFile)sourceRes).getContents();
                this.copyTemplateToTempDirectory(is, pluginTempDir, destPathName.toString(), env, monitor);
            }
            catch (CoreException e) {
                status = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_BAKCUP_SOAP_IMPL_FILE, (Object[])new String[]{sourcePathName}), (Throwable)e);
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private void moveIFile(IWorkspaceRoot root, IPath sourcePath, IPath destPath) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IResource sourceRes = this.getResourceForLocation(root, sourcePath);
        if (sourceRes != null) {
            IResource destRes = this.getResourceForLocation(root, destPath);
            if (destRes == null) {
                sourceRes.copy(destPath, 2, (IProgressMonitor)monitor);
            } else if (sourceRes instanceof IFile && destRes instanceof IFile) {
                ((IFile)destRes).setContents(((IFile)sourceRes).getContents(), true, true, (IProgressMonitor)monitor);
            }
        }
    }

    private IResource getResourceForLocation(IWorkspaceRoot root, IPath location) {
        IContainer res = root.getContainerForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        res = root.getFileForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        return root.findMember(location, true);
    }

    private String getPluginTempDir() {
        String pluginTempDir = WebServiceWasConsumptionUIPlugin.getInstance().getStateLocation().toString();
        return pluginTempDir;
    }

    private void copyTemplateToTempDirectory(InputStream is, String pluginTempDir, String fileName, IEnvironment env, IProgressMonitor monitor) {
        try {
            String inputLine;
            int startIdx = fileName.indexOf(File.separator);
            int lastIdx = fileName.lastIndexOf(File.separator);
            File file = null;
            if (lastIdx != -1 && lastIdx != startIdx) {
                String tempSubDir = fileName.substring(0, lastIdx);
                file = new File(String.valueOf(pluginTempDir) + tempSubDir);
            } else {
                file = new File(pluginTempDir);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(pluginTempDir) + fileName);
            DataInputStream dis = new DataInputStream(is);
            while ((inputLine = dis.readLine()) != null) {
                fw.write(inputLine);
                fw.write(System.getProperty("line.separator"));
            }
            fw.flush();
            fw.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public void setWsdl2JavaCommand(AbstractEmitterCommand wsdl2JavaCommand) {
        if (wsdl2JavaCommand instanceof AbstractWSDL2JavaCommand) {
            this.wsdl2JavaCommand_ = wsdl2JavaCommand;
        }
    }
}

