/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import javax.wsdl.Definition;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.Utils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ValidateWSDLTask
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam_;
    private String wSDLServiceURL;
    private String wSDLServicePathname;
    private WebServicesParser wSParser;

    public ValidateWSDLTask(JavaWSDLParameterBase javaWSDLParam) {
        this();
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public ValidateWSDLTask() {
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        int numServices;
        Definition definition;
        String wsdlLocation = this.javaWSDLParam_.getInputWsdlLocation();
        if (!(wsdlLocation != null && wsdlLocation.length() > 0 || (wsdlLocation = this.wSDLServiceURL) != null && wsdlLocation.length() > 0)) {
            wsdlLocation = new Utils().toFileSystemURI(this.wSDLServicePathname);
        }
        if (wsdlLocation != null && wsdlLocation.length() > 0 && (definition = this.wSParser.getWSDLDefinition(wsdlLocation)) != null && (numServices = definition.getServices().size()) < 1) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WSDL_HAS_NO_SERVICE_ELEMENT, (Object[])new Object[]{wsdlLocation}));
        }
        return Status.OK_STATUS;
    }

    public void setWSDLServicePathname(String servicePathname) {
        this.wSDLServicePathname = servicePathname;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.wSDLServiceURL = serviceURL;
    }

    public void setWSParser(WebServicesParser parser) {
        this.wSParser = parser;
    }
}

