/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import javax.wsdl.Definition;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ValidateWSDLCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private boolean ignoreNumberOfService = false;

    public ValidateWSDLCommand() {
    }

    public ValidateWSDLCommand(boolean ignoreNumberOfService) {
        this.ignoreNumberOfService = ignoreNumberOfService;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        int numServices;
        Definition definition;
        if (this.wsdlURI != null && this.wsdlURI.length() > 0 && (definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI)) != null && !this.ignoreNumberOfService && (numServices = definition.getServices().size()) < 1) {
            IEnvironment env = super.getEnvironment();
            IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WSDL_HAS_NO_SERVICE_ELEMENT, (Object[])new Object[]{this.wsdlURI}));
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }
}

