/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class MoveDeploymentFilesTask
extends AbstractDataModelOperation {
    private final String WEB_INF = "WEB-INF";
    private final String META_INF = "META-INF";
    private JavaWSDLParameterBase javaParameter_ = null;
    private IProject serviceProject;
    private String eJBProjectName;
    private IProject proxyProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        byte type = this.javaParameter_.getServerSide();
        IProject project = type == 1 ? this.serviceProject : (type == 2 ? ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName) : this.proxyProject);
        String outputLocation = PlatformUtils.getPathFromPlatform(this.javaParameter_.getOutput());
        try {
            if (!J2EEUtils.isWebProject((IProject)project)) {
                return Status.OK_STATUS;
            }
        }
        catch (Exception ex) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_INTERAL, (Throwable)ex);
        }
        IPath webContentPath = ResourceUtils.getWebComponentServerRoot((IProject)project).getFullPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            this.moveResource(root, (IPath)new Path(outputLocation), webContentPath, "WEB-INF", monitor);
            this.moveResource(root, (IPath)new Path(outputLocation), webContentPath, "META-INF", monitor);
        }
        catch (CoreException e) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{project.toString(), outputLocation.toString(), webContentPath.toString()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void moveResource(IWorkspaceRoot root, IPath source, IPath dest, String res, IProgressMonitor monitor) throws CoreException {
        IPath sourcePath = source.addTrailingSeparator().append(res);
        IPath destPath = dest.addTrailingSeparator().append(res);
        IResource sourceRes = this.getResourceForLocation(root, sourcePath);
        if (sourceRes != null) {
            IResource destRes = this.getResourceForLocation(root, destPath);
            if (destRes == null) {
                sourceRes.copy(destPath, true, monitor);
                try {
                    sourceRes.delete(true, monitor);
                }
                catch (Exception e) {
                    this.getEnvironment().getLog().log(1, 6999, (Object)this, "moveResource", StatusUtils.infoStatus((String)("temporarily ignoring exception: " + e.getMessage())));
                }
            } else if (sourceRes instanceof IFile && destRes instanceof IFile) {
                ((IFile)destRes).delete(true, false, monitor);
                ((IFile)sourceRes).copy(destPath, true, monitor);
                try {
                    ((IFile)sourceRes).delete(true, monitor);
                }
                catch (Exception e) {
                    this.getEnvironment().getLog().log(1, 6999, (Object)this, "moveResource", StatusUtils.infoStatus((String)("temporarily ignoring exception: " + e.getMessage())));
                }
            } else if (sourceRes instanceof IFolder && destRes instanceof IFolder) {
                IResource[] members = ((IFolder)sourceRes).members(true);
                int i = 0;
                while (i < members.length) {
                    IPath memberLocation = members[i].getLocation();
                    this.moveResource(root, memberLocation.uptoSegment(memberLocation.segmentCount() - 1), destPath, memberLocation.lastSegment(), monitor);
                    ++i;
                }
            }
        }
    }

    private IResource getResourceForLocation(IWorkspaceRoot root, IPath location) {
        IContainer res = root.getContainerForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        res = root.getFileForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        return root.findMember(location, true);
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaParameter_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaParameter) {
        this.javaParameter_ = javaParameter;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }
}

