/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.servertarget.ServerTargetHelper;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class AddJarsToProjectBuildPathTask
extends AbstractDataModelOperation {
    private String J2EE_WEB = "j2ee.web";
    private String J2EE_EJB = "j2ee.ejb";
    private IJavaProject javaProject_;
    private IClasspathEntry[] oldClasspath_;
    private IClasspathEntry[] newClasspath_;
    private JavaWSDLParameterBase javaParameter_ = null;
    private IProject project_ = null;
    private boolean isJ2EE_13 = true;
    private String eJBProjectName;
    private IProject serviceProject;
    private IProject proxyProject;
    private String serverInstanceId;
    private String clientProjectType = "";
    private String clientServerType;
    private Boolean testService;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (!this.clientProjectType.equals("com.ibm.etools.webservice.consumption.ui.clientProjectType.Containerless")) {
            if (ServerSelectionUtils.getRuntimeTarget((String)this.proxyProject.getName()) == null) {
                return this.addJarsForV5SimpleClient(this.proxyProject);
            }
            return Status.OK_STATUS;
        }
        IStatus status = this.setRuntimeTarget(this.proxyProject);
        return status;
    }

    private IStatus setRuntimeTarget(IProject javaProject) {
        block6: {
            try {
                if (this.serverInstanceId == null) {
                    IServer[] servers = ServerCore.getServers();
                    int i = 0;
                    while (i < servers.length) {
                        IServer curServer = servers[i];
                        if (curServer.getServerType().getId().equals(this.clientServerType)) {
                            break block6;
                        }
                        ++i;
                    }
                    break block6;
                }
                ServerCore.findServer((String)this.serverInstanceId);
            }
            catch (Exception exception) {
                if (this.javaParameter_.getJ2eeLevel().equals("1.4")) {
                    return this.addJarsForV6SimpleClient(this.proxyProject);
                }
                return this.addJarsForV5SimpleClient(this.proxyProject);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus addJarsForV6SimpleClient(IProject javaProject) {
        IStatus status = this.addJar(javaProject, "com.ibm.websphere.rt.v6", "lib/webservices.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "com.ibm.websphere.rt.v6", "lib/j2ee.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "com.ibm.websphere.rt.v6", "lib/channel.http.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "com.ibm.websphere.rt.v6", "lib/channel.tcp.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "com.ibm.websphere.rt.v6", "lib/channelfw.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "com.ibm.etools.j2ee.core.ws.ext", "runtime/utils.jar");
        if (status != null) {
            return status;
        }
        status = this.addJar(javaProject, "org.eclipse.hyades.logging.core", "hlcbe101.jar");
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus addJarsForV5SimpleClient(IProject javaProject) {
        IStatus status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/commons-discovery.jar");
        if (status != null) {
            return status;
        }
        status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/commons-logging-api.jar");
        if (status != null) {
            return status;
        }
        status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/webservices.jar");
        if (status != null) {
            return status;
        }
        status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/qname.jar");
        if (status != null) {
            return status;
        }
        status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/wsdl4j.jar");
        if (status != null) {
            return status;
        }
        status = this.addVariableJar(javaProject, "WAS_50_PLUGINDIR", "lib/j2ee.jar");
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private final IStatus targetServer(IProject aProject, String serverId, String typeId) {
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (!serverId.equals("com.ibm.websphere.v51.server.base") && !serverId.equals("com.ibm.websphere.v51.server.remote.base")) break block6;
                            ServerTargetHelper.cleanUpNonServerTargetClasspath((IProject)aProject);
                            return null;
                        }
                        catch (Exception e) {
                            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
                        }
                    }
                    if (!serverId.equals("com.ibm.websphere.v51.server.express") && !serverId.equals("com.ibm.websphere.v51.server.remote.express")) break block7;
                    ServerTargetHelper.cleanUpNonServerTargetClasspath((IProject)aProject);
                    return null;
                }
                if (!serverId.equals("com.ibm.websphere.v5.server.base") && !serverId.equals("com.ibm.websphere.v5.server.remote.base")) break block8;
                ServerTargetHelper.cleanUpNonServerTargetClasspath((IProject)aProject);
                return null;
            }
            if (!serverId.equals("com.ibm.websphere.v5.server.express") && !serverId.equals("com.ibm.websphere.v5.server.remote.express")) break block9;
            ServerTargetHelper.cleanUpNonServerTargetClasspath((IProject)aProject);
            return null;
        }
        this.add_WAS_50_PLUGINDIR_VARIABLE_Jars(aProject);
        return null;
    }

    private final void add_WAS_50_PLUGINDIR_VARIABLE_Jars(IProject aProject) {
    }

    private final IStatus addJar(IProject webProject, String pluginId, String jarName) {
        block10: {
            this.javaProject_ = null;
            this.oldClasspath_ = null;
            try {
                this.javaProject_ = JavaCore.create((IProject)webProject);
                if (this.javaProject_ != null) {
                    this.oldClasspath_ = this.javaProject_.getRawClasspath();
                    break block10;
                }
                return StatusUtils.errorStatus((String)Messages.MSG_WARN_NO_JAVA_NATURE);
            }
            catch (JavaModelException e) {
                return StatusUtils.errorStatus((String)Messages.MSG_WARN_NO_JAVA_NATURE, (Throwable)e);
            }
        }
        boolean found = false;
        int i = 0;
        while (i < this.oldClasspath_.length) {
            found = found || this.oldClasspath_[i].getPath().toString().toLowerCase().endsWith(jarName.toLowerCase());
            ++i;
        }
        if (found) {
            return null;
        }
        this.newClasspath_ = new IClasspathEntry[this.oldClasspath_.length + 1];
        i = 0;
        while (i < this.oldClasspath_.length) {
            this.newClasspath_[i] = this.oldClasspath_[i];
            ++i;
        }
        try {
            this.newClasspath_[i++] = pluginId != null ? JavaCore.newLibraryEntry((IPath)this.getTheJarPath(pluginId, jarName), null, null) : JavaCore.newVariableEntry((IPath)this.getTheJarPath(pluginId, jarName), null, null);
        }
        catch (CoreException e) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
        }
        try {
            this.javaProject_.setRawClasspath(this.newClasspath_, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
        }
        return null;
    }

    private final IStatus addVariableJar(IProject webProject, String variable, String jarName) {
        block11: {
            this.javaProject_ = null;
            this.oldClasspath_ = null;
            try {
                this.javaProject_ = JavaCore.create((IProject)webProject);
                if (this.javaProject_ != null) {
                    this.oldClasspath_ = this.javaProject_.getRawClasspath();
                    break block11;
                }
                return StatusUtils.errorStatus((String)Messages.MSG_WARN_NO_JAVA_NATURE);
            }
            catch (JavaModelException javaModelException) {
                return StatusUtils.errorStatus((String)Messages.MSG_WARN_NO_JAVA_NATURE);
            }
        }
        boolean found = false;
        int i = 0;
        while (i < this.oldClasspath_.length) {
            found = found || this.oldClasspath_[i].getPath().toString().toLowerCase().endsWith(jarName.toLowerCase());
            ++i;
        }
        if (found) {
            return null;
        }
        this.newClasspath_ = new IClasspathEntry[this.oldClasspath_.length + 1];
        i = 0;
        while (i < this.oldClasspath_.length) {
            this.newClasspath_[i] = this.oldClasspath_[i];
            ++i;
        }
        try {
            if (variable != null) {
                this.newClasspath_[i++] = JavaCore.newVariableEntry((IPath)this.getTheVariableJarPath(variable, jarName), null, null);
            }
        }
        catch (CoreException e) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
        }
        try {
            this.javaProject_.setRawClasspath(this.newClasspath_, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BAD_BUILDPATH);
        }
        return null;
    }

    private final IPath getTheJarPath(String pluginId, String theJar) throws CoreException {
        try {
            if (pluginId != null) {
                IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
                IPluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(pluginId);
                URL localURL = Platform.asLocalURL((URL)new URL(pluginDescriptor.getInstallURL(), theJar));
                return new Path(localURL.getFile());
            }
            return new Path(theJar);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(2, "com.ibm.etools.webservice.was.creation.ui", 0, Messages.MSG_BAD_SOAP_JAR_URL, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "com.ibm.etools.webservice.was.creation.ui", 0, Messages.MSG_BAD_SOAP_JAR_URL, (Throwable)e));
        }
    }

    private final IPath getTheVariableJarPath(String variable, String theJar) throws CoreException {
        if (variable != null) {
            Path varPath = new Path(variable);
            Path jarPath = (Path)varPath.append(theJar);
            return jarPath;
        }
        return new Path(theJar);
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaParameter_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaParameter) {
        this.javaParameter_ = javaParameter;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setClientProjectType(String clientProjectType) {
        this.clientProjectType = clientProjectType;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setClientServerType(String clientServerType) {
        this.clientServerType = clientServerType;
    }

    public void setTestService(Boolean testService) {
        this.testService = testService;
    }
}

