/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.preferences;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationDefaults;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.utils.ServerUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class CodeGenerationPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String INFOPOP_CG_PAGE = "com.ibm.etools.webservice.was.creation.ui.PPCG0001";
    private TabFolder tabFolder;
    private Combo styleAndUse;
    private Text targetNamespace;
    private Button wrapped;
    private Button mime;
    private Combo soapAction;
    private Combo voidReturn;
    private Button http;
    private Button ejb;
    private Button jms;
    private Button genEquals;
    private Button genImplSer;
    private Combo deployScope;
    private Button noWrappedOps;
    private Button noWrappedArrays;
    private Button relativeNamespace;
    private Button noDataBinding;
    private Button generateSDOFacades;
    private Button jaxrpcValidation;
    private Button doNotOverwriteLoadableClasses;
    private Button backupDD;
    private Button genAllJavaTypes;
    private Button noWarning;
    private TabItem v6ThinClientTabItem;
    private Button useV6ThinClient;
    private Label v6ThinClientPathLabel;
    private Text v6ThinClientPath;
    private Button v6ThinClientDetectButton;
    private Button v6ThinClientBrowseButton;
    private boolean areV6ToolsInstalled;

    protected Control createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setToolTipText(Messages.TOOLTIP_EMITTER_PAGE);
        TabItem java2wsdl = new TabItem(this.tabFolder, 0);
        java2wsdl.setText(Messages.LABEL_EMITTER_JAVA2WSDL);
        java2wsdl.setControl(this.createJava2WSDLPage((Composite)this.tabFolder));
        TabItem wsdl2java = new TabItem(this.tabFolder, 0);
        wsdl2java.setText(Messages.LABEL_EMITTER_WSDL2JAVA);
        wsdl2java.setControl(this.createWSDL2JavaPage((Composite)this.tabFolder));
        boolean bl = this.areV6ToolsInstalled = ServerUtils.getWebSphereV6StubRuntime() != null;
        if (this.areV6ToolsInstalled) {
            this.v6ThinClientTabItem = new TabItem(this.tabFolder, 0);
            this.v6ThinClientTabItem.setText(Messages.LABEL_V6_THINCLIENT);
            this.v6ThinClientTabItem.setControl(this.createV6ThinClientPage((Composite)this.tabFolder));
        }
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        return this.tabFolder;
    }

    private Control createJava2WSDLPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.LABEL_EMITTER_STYLE_AND_USE);
        label.setToolTipText(Messages.TOOLTIP_EMITTER_STYLE_AND_USE);
        this.styleAndUse = new Combo(composite, 8);
        this.styleAndUse.setLayoutData((Object)new GridData(256));
        this.styleAndUse.setItems(new String[]{Messages.COMBO_EMITTER_DOCLIT, Messages.COMBO_EMITTER_RPCLIT, Messages.COMBO_EMITTER_RPCENC});
        this.styleAndUse.setToolTipText(Messages.TOOLTIP_EMITTER_STYLE_AND_USE);
        label = new Label(composite, 0);
        label.setText(Messages.LABEL_EMITTER_TARGET_NAMESPACE);
        label.setToolTipText(Messages.TOOLTIP_EMITTER_TARGET_NAMESPACE);
        this.targetNamespace = new Text(composite, 2052);
        this.targetNamespace.setLayoutData((Object)new GridData(256));
        this.targetNamespace.setToolTipText(Messages.TOOLTIP_EMITTER_TARGET_NAMESPACE);
        this.wrapped = this.createCheckBox(composite, Messages.BUTTON_EMITTER_WRAPPED);
        GridData gridData = new GridData(768);
        this.wrapped.setLayoutData((Object)gridData);
        this.wrapped.setToolTipText(Messages.TOOLTIP_EMITTER_WRAPPED);
        new Label(composite, 0).setText("");
        this.mime = this.createCheckBox(composite, Messages.BUTTON_EMITTER_MIME);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mime.setLayoutData((Object)gridData);
        this.mime.setToolTipText(Messages.TOOLTIP_EMITTER_MIME);
        label = new Label(composite, 0);
        label.setText(Messages.LABEL_EMITTER_SOAPACTION);
        label.setToolTipText(Messages.TOOLTIP_EMITTER_SOAPACTION);
        this.soapAction = new Combo(composite, 8);
        this.soapAction.setLayoutData((Object)new GridData(256));
        this.soapAction.setItems(new String[]{Messages.COMBO_EMITTER_OPERATION, Messages.COMBO_EMITTER_NONE, Messages.COMBO_EMITTER_DEFAULT});
        this.soapAction.setToolTipText(Messages.TOOLTIP_EMITTER_SOAPACTION);
        label = new Label(composite, 0);
        label.setText(Messages.LABEL_EMITTER_VOIDRETURN);
        label.setToolTipText(Messages.TOOLTIP_EMITTER_VOIDRETURN);
        this.voidReturn = new Combo(composite, 8);
        this.voidReturn.setLayoutData((Object)new GridData(256));
        this.voidReturn.setItems(new String[]{Messages.COMBO_EMITTER_ONEWAY, Messages.COMBO_EMITTER_TWOWAY});
        this.voidReturn.setToolTipText(Messages.TOOLTIP_EMITTER_VOIDRETURN);
        Group bindings = new Group(composite, 0);
        bindings.setText(Messages.GROUP_EMITTER_BINDINGS);
        layout = new GridLayout();
        layout.numColumns = 3;
        bindings.setLayout((Layout)layout);
        gridData = new GridData(256);
        gridData.verticalAlignment = 1040;
        gridData.horizontalSpan = 2;
        bindings.setLayoutData((Object)gridData);
        bindings.setToolTipText(Messages.TOOLTIP_EMITTER_BINDINGS);
        this.http = this.createCheckBox((Composite)bindings, Messages.BUTTON_EMITTER_HTTP);
        this.http.setLayoutData((Object)new GridData(768));
        this.http.setToolTipText(Messages.TOOLTIP_EMITTER_HTTP);
        this.ejb = this.createCheckBox((Composite)bindings, Messages.BUTTON_EMITTER_EJB);
        this.ejb.setLayoutData((Object)new GridData(768));
        this.ejb.setToolTipText(Messages.TOOLTIP_EMITTER_EJB);
        this.jms = this.createCheckBox((Composite)bindings, Messages.BUTTON_EMITTER_JMS);
        this.jms.setLayoutData((Object)new GridData(768));
        this.jms.setToolTipText(Messages.TOOLTIP_EMITTER_JMS);
        new Label(composite, 0).setText("");
        new Label(composite, 0).setText("");
        this.jaxrpcValidation = this.createCheckBox(composite, Messages.BUTTON_EMITTER_JAXRPC_VALIDATION);
        gridData = new GridData(768);
        this.jaxrpcValidation.setLayoutData((Object)gridData);
        this.jaxrpcValidation.setToolTipText(Messages.TOOLTIP_EMITTER_JAXRPC_VALIDATION);
        return composite;
    }

    private Control createWSDL2JavaPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.LABEL_EMITTER_DEPLOYSCOPE);
        label.setToolTipText(Messages.TOOLTIP_EMITTER_DEPLOYSCOPE);
        this.deployScope = new Combo(composite, 8);
        this.deployScope.setItems(new String[]{Messages.COMBO_EMITTER_DEFAULT_DEPLOYSCOPE, Messages.COMBO_EMITTER_REQUEST, Messages.COMBO_EMITTER_SESSION, Messages.COMBO_EMITTER_APPLICATION});
        this.deployScope.setLayoutData((Object)new GridData(256));
        this.deployScope.setToolTipText(Messages.TOOLTIP_EMITTER_DEPLOYSCOPE);
        this.noWrappedOps = this.createCheckBox(composite, Messages.BUTTON_EMITTER_NOWRAPPEDOPS);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.noWrappedOps.setLayoutData((Object)gridData);
        this.noWrappedOps.setToolTipText(Messages.TOOLTIP_EMITTER_NOWRAPPEDOPS);
        this.noDataBinding = this.createCheckBox(composite, Messages.BUTTON_EMITTER_NO_DATABINDING);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.noDataBinding.setLayoutData((Object)gridData);
        this.noDataBinding.setToolTipText(Messages.TOOLTIP_EMITTER_NO_DATABINDING);
        this.generateSDOFacades = this.createCheckBox(composite, Messages.BUTTON_EMITTER_GENERATE_SDO);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.generateSDOFacades.setLayoutData((Object)gridData);
        this.generateSDOFacades.setToolTipText(Messages.TOOLTIP_EMITTER_GENERATE_SDO);
        this.doNotOverwriteLoadableClasses = this.createCheckBox(composite, Messages.BUTTON_EMITTER_DO_NOT_OVERWRITE_LOADABLE_CLASSES);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.doNotOverwriteLoadableClasses.setLayoutData((Object)gridData);
        this.doNotOverwriteLoadableClasses.setToolTipText(Messages.TOOLTIP_EMITTER_DO_NOT_OVERWRITE_LOADABLE_CLASSES);
        this.backupDD = this.createCheckBox(composite, Messages.BUTTON_EMITTER_BACKUP_WSDD);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.backupDD.setLayoutData((Object)gridData);
        this.backupDD.setToolTipText(Messages.TOOLTIP_EMITTER_BACKUP_WSDD);
        this.genAllJavaTypes = this.createCheckBox(composite, Messages.BUTTON_EMITTER_GEN_ALL_JAVA_TYPES);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.genAllJavaTypes.setLayoutData((Object)gridData);
        this.genAllJavaTypes.setToolTipText(Messages.TOOLTIP_EMITTER_GEN_ALL_JAVA_TYPES);
        this.noWarning = this.createCheckBox(composite, Messages.BUTTON_EMITTER_NO_WARNING);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.noWarning.setLayoutData((Object)gridData);
        this.noWarning.setToolTipText(Messages.TOOLTIP_EMITTER_NO_WARNING);
        Group v6 = new Group(composite, 0);
        v6.setText(Messages.GROUP_EMITTER_V6);
        layout = new GridLayout();
        layout.numColumns = 2;
        v6.setLayout((Layout)layout);
        gridData = new GridData(256);
        gridData.verticalAlignment = 1040;
        gridData.horizontalSpan = 2;
        v6.setLayoutData((Object)gridData);
        v6.setToolTipText(Messages.TOOLTIP_EMITTER_V6);
        this.noWrappedArrays = this.createCheckBox((Composite)v6, Messages.BUTTON_EMITTER_NOWRAPPEDARRAYS);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.noWrappedArrays.setLayoutData((Object)gridData);
        this.noWrappedArrays.setToolTipText(Messages.TOOLTIP_EMITTER_NOWRAPPEDARRAYS);
        this.genEquals = this.createCheckBox((Composite)v6, Messages.BUTTON_EMITTER_GENEQUALS);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.genEquals.setLayoutData((Object)gridData);
        this.genEquals.setToolTipText(Messages.TOOLTIP_EMITTER_GENEQUALS);
        this.genImplSer = this.createCheckBox((Composite)v6, Messages.BUTTON_EMITTER_GENIMPLSER);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.genImplSer.setLayoutData((Object)gridData);
        this.genImplSer.setToolTipText(Messages.TOOLTIP_EMITTER_GENIMPLSER);
        this.relativeNamespace = this.createCheckBox((Composite)v6, Messages.BUTTON_EMITTER_RELATIVENAMESPACE);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.relativeNamespace.setLayoutData((Object)gridData);
        this.relativeNamespace.setToolTipText(Messages.TOOLTIP_EMITTER_RELATIVENAMESPACE);
        return composite;
    }

    private Control createV6ThinClientPage(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        this.useV6ThinClient = this.createCheckBox(composite, Messages.BUTTON_USE_V6_THINCLIENT);
        this.useV6ThinClient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean shouldUseV6ThinClient = CodeGenerationPage.this.useV6ThinClient.getSelection();
                CodeGenerationPage.this.setStateForUseV6ThinClientControls(shouldUseV6ThinClient);
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.useV6ThinClient.setLayoutData((Object)gd);
        this.useV6ThinClient.setToolTipText(Messages.TOOLTIP_USE_V6_THINCLIENT);
        Composite v6ThinClientSettings = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        v6ThinClientSettings.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        v6ThinClientSettings.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.v6ThinClientPathLabel = new Label(v6ThinClientSettings, 0);
        this.v6ThinClientPathLabel.setLayoutData((Object)gd);
        this.v6ThinClientPathLabel.setText(Messages.LABEL_V6_THINCLIENT_PATH);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.v6ThinClientPath = new Text(v6ThinClientSettings, 2052);
        this.v6ThinClientPath.setLayoutData((Object)gd);
        this.v6ThinClientPath.setToolTipText(Messages.TOOLTIP_V6_THINCLIENT_PATH);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 128;
        this.v6ThinClientDetectButton = new Button(v6ThinClientSettings, 0);
        this.v6ThinClientDetectButton.setLayoutData((Object)gd);
        this.v6ThinClientDetectButton.setText(Messages.BUTTON_DETECT);
        this.v6ThinClientDetectButton.setToolTipText(Messages.TOOLTIP_V6_THINCLIENT_DETECT);
        this.v6ThinClientDetectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IRuntime[] runtimes;
                IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
                int n = runtimes.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath jarPath;
                    File jarFile;
                    IRuntime runtime = iRuntimeArray[n2];
                    if (WASRuntimeUtil.isWASv60Runtime((IRuntime)runtime) && (jarFile = (jarPath = runtime.getLocation().addTrailingSeparator().append("runtimes/ibm-jaxrpc-client.jar")).toFile()).exists()) {
                        CodeGenerationPage.this.v6ThinClientPath.setText(jarFile.getAbsolutePath());
                        return;
                    }
                    ++n2;
                }
                MessageBox mb = new MessageBox(CodeGenerationPage.this.getShell(), 1);
                mb.setText(Messages.MB_TITLE_V6_THINCLIENT_NOT_DETECTED);
                mb.setMessage(Messages.MSG_ERROR_THINCLIENT_NOT_DETECTED);
                mb.open();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 128;
        this.v6ThinClientBrowseButton = new Button(v6ThinClientSettings, 0);
        this.v6ThinClientBrowseButton.setLayoutData((Object)gd);
        this.v6ThinClientBrowseButton.setText(Messages.BUTTON_BROWSE);
        this.v6ThinClientBrowseButton.setToolTipText(Messages.TOOLTIP_V6_THINCLIENT_BROWSE);
        this.v6ThinClientBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(composite.getShell());
                dlg.setFilterNames(new String[]{"ibm-jaxrpc-client.jar"});
                dlg.setFilterExtensions(new String[]{"ibm-jaxrpc-client.jar"});
                String v6ThinClientPathName = dlg.open();
                if (v6ThinClientPathName != null) {
                    CodeGenerationPage.this.v6ThinClientPath.setText(v6ThinClientPathName);
                }
            }
        });
        return composite;
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        File thinClientJar;
        if (this.areV6ToolsInstalled && this.useV6ThinClient.getSelection() && !(thinClientJar = new File(this.v6ThinClientPath.getText().trim())).exists()) {
            MessageBox mb = new MessageBox(this.getShell(), 1);
            mb.setText(Messages.MB_TITLE_INVALID_V6_THINCLIENT);
            mb.setMessage(NLS.bind((String)Messages.MSG_ERROR_INVALID_V6_THINCLIENT, (Object)thinClientJar.getAbsolutePath()));
            mb.open();
            this.tabFolder.setSelection(this.v6ThinClientTabItem);
            return false;
        }
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.targetNamespace.setText(CodeGenerationDefaults.getTargetNamespace());
        this.wrapped.setSelection(CodeGenerationDefaults.getWrapped());
        this.mime.setSelection(CodeGenerationDefaults.getMIME());
        this.styleAndUse.select(CodeGenerationDefaults.getStyleAndUse());
        this.soapAction.select(CodeGenerationDefaults.getSoapAction());
        this.voidReturn.select(CodeGenerationDefaults.getVoidReturn());
        this.http.setSelection(CodeGenerationDefaults.getHTTP());
        this.ejb.setSelection(CodeGenerationDefaults.getEJB());
        this.jms.setSelection(CodeGenerationDefaults.getJMS());
        this.jaxrpcValidation.setSelection(CodeGenerationDefaults.getJaxrpcValidation());
        this.genEquals.setSelection(CodeGenerationDefaults.getGenEquals());
        this.genImplSer.setSelection(CodeGenerationDefaults.getGenImplSer());
        this.deployScope.select(CodeGenerationDefaults.getDeployScope());
        this.noWrappedOps.setSelection(CodeGenerationDefaults.getNoWrappedOps());
        this.noWrappedArrays.setSelection(CodeGenerationDefaults.getNoWrappedArrays());
        this.noDataBinding.setSelection(CodeGenerationDefaults.getNoDataBinding());
        this.generateSDOFacades.setSelection(CodeGenerationDefaults.getGenerateSDO());
        this.doNotOverwriteLoadableClasses.setSelection(CodeGenerationDefaults.getNoOverwriteLoadableClasses());
        this.backupDD.setSelection(CodeGenerationDefaults.getBackupDD());
        this.genAllJavaTypes.setSelection(CodeGenerationDefaults.getGenAllJavaTypes());
        this.noWarning.setSelection(CodeGenerationDefaults.getNoWarning());
        this.relativeNamespace.setSelection(CodeGenerationDefaults.getRelativeNamespace());
        if (this.areV6ToolsInstalled) {
            this.useV6ThinClient.setSelection(CodeGenerationDefaults.getUseV6ThinClient());
            this.v6ThinClientPath.setText(CodeGenerationDefaults.getV6ThinClientPath());
            this.setStateForUseV6ThinClientControls(this.useV6ThinClient.getSelection());
        }
    }

    private void setStateForUseV6ThinClientControls(boolean isEnabled) {
        this.v6ThinClientPathLabel.setEnabled(isEnabled);
        this.v6ThinClientPath.setEnabled(isEnabled);
        this.v6ThinClientDetectButton.setEnabled(isEnabled);
        this.v6ThinClientBrowseButton.setEnabled(isEnabled);
    }

    private void initializeValues() {
        CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
        this.targetNamespace.setText(context.getTargetNamespace());
        this.wrapped.setSelection(context.isWrapped());
        this.mime.setSelection(context.isMIME());
        this.styleAndUse.select(context.getSyleAndUse());
        this.soapAction.select(context.getSoapAction());
        this.voidReturn.select(context.getVoidReturn());
        this.http.setSelection(context.isHTTPBinding());
        this.ejb.setSelection(context.isEJBBinding());
        this.jms.setSelection(context.isJMSBinding());
        this.jaxrpcValidation.setSelection(context.isJAXRPCValidationEnabled());
        this.genEquals.setSelection(context.isGenEquals());
        this.genImplSer.setSelection(context.isGenImplSer());
        this.deployScope.select(context.getDeployScope());
        this.noWrappedOps.setSelection(context.isNoWrappedOps());
        this.noWrappedArrays.setSelection(context.isNoWrappedArrays());
        this.noDataBinding.setSelection(context.isNoDataBindings());
        this.generateSDOFacades.setSelection(context.isGenerateSDO());
        this.doNotOverwriteLoadableClasses.setSelection(context.isNoOverwriteLoadableClasses());
        this.backupDD.setSelection(context.isBackupDD());
        this.genAllJavaTypes.setSelection(context.isGenAllJavaTypes());
        this.noWarning.setSelection(context.isNoWarning());
        this.relativeNamespace.setSelection(context.isRelativeNamespace());
        if (this.areV6ToolsInstalled) {
            this.useV6ThinClient.setSelection(context.isUseV6ThinClient());
            this.v6ThinClientPath.setText(context.getV6ThinClientPath().trim());
            this.setStateForUseV6ThinClientControls(this.useV6ThinClient.getSelection());
        }
    }

    private void storeValues() {
        CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
        context.setStyleAndUse(this.styleAndUse.getSelectionIndex());
        context.setTargetNamespace(this.targetNamespace.getText());
        context.setWrapped(this.wrapped.getSelection());
        context.setMIME(this.mime.getSelection());
        context.setSoapAction(this.soapAction.getSelectionIndex());
        context.setVoidReturn(this.voidReturn.getSelectionIndex());
        context.setHTTPBinding(this.http.getSelection());
        context.setEJBBinding(this.ejb.getSelection());
        context.setJMSBinding(this.jms.getSelection());
        context.setJAXRPCValidationEnabled(this.jaxrpcValidation.getSelection());
        context.setGenEquals(this.genEquals.getSelection());
        context.setGenImplSer(this.genImplSer.getSelection());
        context.setDeployScope(this.deployScope.getSelectionIndex());
        context.setNoWrappedOps(this.noWrappedOps.getSelection());
        context.setNoWrappedArrays(this.noWrappedArrays.getSelection());
        context.setNoDataBindings(this.noDataBinding.getSelection());
        context.setGenerateSDO(this.generateSDOFacades.getSelection());
        context.setNoOverwriteLoadableClasses(this.doNotOverwriteLoadableClasses.getSelection());
        context.setBackupDD(this.backupDD.getSelection());
        context.setGenAllJavaTypes(this.genAllJavaTypes.getSelection());
        context.setNoWarning(this.noWarning.getSelection());
        context.setRelativeNamespace(this.relativeNamespace.getSelection());
        if (this.areV6ToolsInstalled) {
            boolean isUseV6ThinClient = this.useV6ThinClient.getSelection();
            context.setUseV6ThinClient(isUseV6ThinClient);
            String v6ThinClientPathString = this.v6ThinClientPath.getText().trim();
            context.setV6ThinClientPath(v6ThinClientPathString);
            if (isUseV6ThinClient) {
                RdPlugin.getDefault().setUpV6ClassPathVariable(true);
            }
        }
    }
}

