/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.j2ee.ejb.creation.operations.CreateSessionBeanDataModelProvider;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ValidateClientEJBJarXMLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam;
    private IProject clientProject;
    private String clientProjectType;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (!this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
            return Status.OK_STATUS;
        }
        if (this.clientProjectType != null && !this.clientProjectType.equals("org.eclipse.jst.ws.consumption.ui.clientProjectType.EJB")) {
            return Status.OK_STATUS;
        }
        if (!J2EEUtils.isEJBProject((IProject)this.clientProject)) {
            return Status.OK_STATUS;
        }
        J2EEUtils.createEJBDeploymentDescriptor((IProject)this.clientProject);
        boolean needToCreateDefaultSessionBean = false;
        EJBArtifactEdit artifactEdit = null;
        IEnvironment env = super.getEnvironment();
        try {
            try {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.clientProject);
                EJBJar ejbJar = artifactEdit.getEJBJar();
                EList ejbs = ejbJar.getEnterpriseBeans();
                if (ejbs.size() == 0) {
                    needToCreateDefaultSessionBean = true;
                }
            }
            catch (Exception e) {
                IStatus errorStatus = StatusUtils.errorStatus((String)e.getLocalizedMessage(), (Throwable)e);
                env.getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        if (needToCreateDefaultSessionBean) {
            this.createDefaultSessionBean(env);
        }
        return Status.OK_STATUS;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject = clientProject;
    }

    public void setClientProjectType(String clientProjectType) {
        this.clientProjectType = clientProjectType;
    }

    private IStatus createDefaultSessionBean(IEnvironment env) {
        try {
            IDataModel m = DataModelFactory.createDataModel((IDataModelProvider)new CreateSessionBeanDataModelProvider());
            m.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.clientProject.getName());
            m.setProperty("ICreateEnterpriseBeanDataModelProperties.beanName", (Object)"DefaultSession");
            m.setProperty("ICreateEnterpriseBeanDataModelProperties.defaultPackageName", (Object)"ejbs");
            m.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERR_NO_EJB_DEFINED);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }
}

