/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class UpdateRelativeWSDLPathCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private IProject proxyProject;
    private String wsdlRelativePath = null;
    private boolean isContainerless = false;
    private WebServicesParser webServicesParser;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.wsdlRelativePath == null) {
            return Status.OK_STATUS;
        }
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.isContainerless) {
            return Status.OK_STATUS;
        }
        if (this.proxyProject == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
        }
        if (this.javaWSDLParam.getJ2eeLevel().equals("1.3")) {
            return this.updateWebServicesClientXml(monitor);
        }
        return this.updateJ2EEServiceRef(monitor);
    }

    private IStatus updateWebServicesClientXml(IProgressMonitor monitor) {
        WSCDDArtifactEdit artifactEdit = null;
        HashSet serviceRefList = this.getServiceRefList();
        try {
            try {
                artifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForWrite((IProject)this.proxyProject);
                WebServicesClient webservicesclient = artifactEdit.getWebServicesClient();
                if (this.javaWSDLParam.getServerSide() == 4) {
                    for (ComponentScopedRefs compScopedRef : webservicesclient.getComponentScopedRefs()) {
                        EList serviceRefs = compScopedRef.getServiceRefs();
                        if (serviceRefs == null) continue;
                        this.updateServiceRefWsdl((List)serviceRefs, serviceRefList);
                    }
                } else {
                    EList serviceRefs = webservicesclient.getServiceRefs();
                    if (serviceRefs != null) {
                        this.updateServiceRefWsdl((List)serviceRefs, serviceRefList);
                    }
                }
                artifactEdit.saveIfNecessary(monitor);
            }
            catch (Exception e) {
                IStatus iStatus = StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICESCLIENT_XML) + ": " + e), (Throwable)e);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                    artifactEdit = null;
                }
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
                artifactEdit = null;
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus updateJ2EEServiceRef(IProgressMonitor monitor) {
        HashSet serviceRefList = this.getServiceRefList();
        if (this.javaWSDLParam.getServerSide() == 0) {
            WebArtifactEdit webEdit = null;
            try {
                try {
                    webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.proxyProject);
                    WebApp webapp = webEdit.getWebApp();
                    this.updateServiceRefWsdl((List)webapp.getServiceRefs(), serviceRefList);
                    webEdit.saveIfNecessary(monitor);
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    if (webEdit == null) return Status.OK_STATUS;
                    webEdit.dispose();
                    webEdit = null;
                }
                return Status.OK_STATUS;
            }
            finally {
                if (webEdit != null) {
                    webEdit.dispose();
                    webEdit = null;
                }
            }
        }
        if (this.javaWSDLParam.getServerSide() == 4) {
            EJBArtifactEdit ejbEdit = null;
            try {
                try {
                    ejbEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.proxyProject);
                    EJBJar ejbJar = ejbEdit.getEJBJar();
                    for (EnterpriseBean ejb : ejbJar.getEnterpriseBeans()) {
                        this.updateServiceRefWsdl((List)ejb.getServiceRefs(), serviceRefList);
                    }
                    ejbEdit.saveIfNecessary(monitor);
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    if (ejbEdit == null) return Status.OK_STATUS;
                    ejbEdit.dispose();
                    ejbEdit = null;
                }
                return Status.OK_STATUS;
            }
            finally {
                if (ejbEdit != null) {
                    ejbEdit.dispose();
                    ejbEdit = null;
                }
            }
        }
        if (this.javaWSDLParam.getServerSide() != 5) return Status.OK_STATUS;
        AppClientArtifactEdit appClientEdit = null;
        try {
            try {
                appClientEdit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IProject)this.proxyProject);
                ApplicationClient appClient = appClientEdit.getApplicationClient();
                this.updateServiceRefWsdl((List)appClient.getServiceRefs(), serviceRefList);
                appClientEdit.saveIfNecessary(monitor);
                return Status.OK_STATUS;
            }
            catch (Exception exception) {
                if (appClientEdit == null) return Status.OK_STATUS;
                appClientEdit.dispose();
                appClientEdit = null;
            }
            return Status.OK_STATUS;
        }
        finally {
            if (appClientEdit != null) {
                appClientEdit.dispose();
                Object var3_5 = null;
            }
        }
    }

    private HashSet getServiceRefList() {
        File file;
        HashSet<String> serviceRefList = new HashSet<String>();
        String inputWsdlLocation = this.javaWSDLParam.getInputWsdlLocation();
        Definition def = this.webServicesParser.getWSDLDefinition(inputWsdlLocation);
        if (def == null && (file = new File(inputWsdlLocation)).exists()) {
            try {
                def = this.webServicesParser.getWSDLDefinition(file.toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Map services = def.getServices();
        for (Service service : services.values()) {
            StringBuffer jndiName = new StringBuffer("service/");
            jndiName.append(service.getQName().getLocalPart());
            serviceRefList.add(jndiName.toString());
        }
        return serviceRefList;
    }

    private IStatus updateServiceRefWsdl(List serviceRefs, HashSet serviceRefNameList) {
        for (ServiceRef serviceRef : serviceRefs) {
            String serviceRefNameInDD = serviceRef.getServiceRefName();
            if (serviceRefNameList == null || !serviceRefNameList.contains(serviceRefNameInDD)) continue;
            serviceRef.setWsdlFile(this.wsdlRelativePath);
        }
        return Status.OK_STATUS;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.isContainerless = javaWSDLParam != null && javaWSDLParam.getContainer() != null && javaWSDLParam.getContainer().equalsIgnoreCase("none");
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlRelativePath(String wsdlRelativePath) {
        this.wsdlRelativePath = wsdlRelativePath;
    }
}

