/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.ui.command.UpdateComponentNameCommand;
import com.ibm.etools.webservice.was.consumption.util.AddSecuritySettingToClientModelUtil;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.ServiceRef;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.internal.wsdd.WsddResourceFactory;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class UpdateIBMWSCExtXMICommand
extends AbstractDataModelOperation {
    private final String WEBSERVICESCLIENT_XML = "webservicesclient.xml";
    private static final String IBM_WEBSERVICESCLIENT_EXT_XMI = "ibm-webservicesclient-ext.xmi";
    private final String IBM_WEBSERVICESCLIENT_EXT_TEMP_XMI = "ibm-webservicesclient-ext-temp.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webservicesClientXmlPath = null;
    IPath ibmWebServicesClientExtXmiPath = null;
    EList newServiceRefs = null;
    ComponentScopedRefs compScopedRef = null;
    private String componentScopedReference = null;
    private IProject proxyProject;
    private String infDir = null;
    private boolean isEjb = false;
    private boolean isContainerless = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.isContainerless) {
            return status;
        }
        IEnvironment environment = super.getEnvironment();
        if (this.javaWSDLParam == null) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        IProject ibmWscExtXmiProject = this.proxyProject;
        if (ibmWscExtXmiProject == null) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        this.getWSCDDFilePath();
        if (this.ibmWebServicesClientExtXmiPath == null) {
            status = this.copyIBMWebServicesClientExtXMIFile(environment, monitor);
            if (this.javaWSDLParam.getSecurityConfig() != 0) {
                WscextArtifactEdit artifactEdit = null;
                try {
                    try {
                        artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
                        WsClientExtension clientExt = artifactEdit.getWsClientExtension();
                        AddSecuritySettingToClientModelUtil.addExtensionSecurity(this.javaWSDLParam, clientExt, this.infDir);
                        if (this.isEjb) {
                            if (this.componentScopedReference == null) {
                                this.componentScopedReference = UpdateComponentNameCommand.getSessionBeanName(ibmWscExtXmiProject);
                            }
                            this.setComponentName(clientExt);
                        }
                        artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        return status;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (artifactEdit == null) return status;
                        artifactEdit.dispose();
                    }
                    return status;
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            if (!this.isEjb) return status;
            WscextArtifactEdit artifactEdit = null;
            try {
                try {
                    artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
                    WsClientExtension clientExt = artifactEdit.getWsClientExtension();
                    if (this.componentScopedReference == null) {
                        this.componentScopedReference = UpdateComponentNameCommand.getSessionBeanName(ibmWscExtXmiProject);
                    }
                    this.setComponentName(clientExt);
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                    return status;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit == null) return status;
                    artifactEdit.dispose();
                }
                return status;
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
        if (context.isBackupDD()) {
            CopyJAXRPCMappingFileUtil.backupWebServicesFile((IEnvironment)environment, (IProgressMonitor)monitor, (String)this.ibmWebServicesClientExtXmiPath.toString(), (IProject)ibmWscExtXmiProject, (String)IBM_WEBSERVICESCLIENT_EXT_XMI);
        }
        try {
            WsClientExtension clientExt = UpdateIBMWSCExtXMICommand.loadResourceFromOutside(this.javaWSDLParam.getTempOutput(), this.infDir, true);
            if (this.javaWSDLParam.getSecurityConfig() != 0) {
                AddSecuritySettingToClientModelUtil.addExtensionSecurity(this.javaWSDLParam, clientExt, this.infDir);
            }
            if (this.isEjb) {
                if (clientExt.getComponentScopedRefs().size() > 0) {
                    this.compScopedRef = (ComponentScopedRefs)clientExt.getComponentScopedRefs().get(0);
                }
            } else if (clientExt.getServiceRefs().size() > 0) {
                this.newServiceRefs = clientExt.getServiceRefs();
            }
            if (this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
                this.updateServiceRef6();
                return status;
            } else {
                this.updateServiceRef5();
            }
            return status;
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_UPDATING_IBM_WEBSERVICESCLIENT_EXT_XMI, (Throwable)e);
            environment.getStatusHandler().reportError(status);
            return status;
        }
    }

    public static WsClientExtension loadResourceFromOutside(String rootPath, String infFolder, boolean needInf) {
        J2EEInit.init();
        WebServiceInit.init();
        WsddResourceFactory.registerWith((RendererFactory)new EMF2DOMRendererFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        String filePath = null;
        filePath = needInf ? String.valueOf(rootPath) + infFolder + File.separator + IBM_WEBSERVICESCLIENT_EXT_XMI : String.valueOf(rootPath) + IBM_WEBSERVICESCLIENT_EXT_XMI;
        filePath = J2EEUtils.removeFileProtocol((String)filePath);
        URI uri = URI.createFileURI((String)filePath);
        try {
            Resource resource = resourceSet.getResource(uri, true);
            EList contents = resource.getContents();
            WsClientExtension clientExt = null;
            int i = 0;
            while (i <= contents.size()) {
                if (contents.get(i) instanceof WsClientExtension) {
                    WsClientExtension wsClientExtension = clientExt = (WsClientExtension)contents.get(i);
                    return wsClientExtension;
                }
                try {
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
        }
        finally {
            WsddResourceFactory.register();
        }
        return null;
    }

    private IStatus copyIBMWebServicesClientExtXMIFile(IEnvironment environment, IProgressMonitor monitor) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform((String)this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + this.infDir + File.separator + IBM_WEBSERVICESCLIENT_EXT_XMI);
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(this.infDir).append(IBM_WEBSERVICESCLIENT_EXT_XMI).makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    private void setComponentName(WsClientExtension clientExt) {
        if (clientExt.getComponentScopedRefs().size() > 0) {
            ComponentScopedRefs componentScopedRef = (ComponentScopedRefs)clientExt.getComponentScopedRefs().get(0);
            componentScopedRef.setComponentNameLink(this.componentScopedReference);
        }
    }

    private void getServiceRef6(IWorkspaceRoot workspace) {
        WscextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForRead((IProject)this.proxyProject);
            WsClientExtension wscext = artifactEdit.getWsClientExtension();
            if (this.javaWSDLParam.getServerSide() == 4) {
                if (wscext.getComponentScopedRefs().size() > 0) {
                    this.compScopedRef = (ComponentScopedRefs)wscext.getComponentScopedRefs().get(0);
                }
            } else if (wscext.getServiceRefs().size() > 0) {
                this.newServiceRefs = wscext.getServiceRefs();
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getServiceRef5(IWorkspaceRoot workspace) {
        WscextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForRead((IProject)this.proxyProject);
            WsClientExtension wscext = artifactEdit.getWsClientExtension();
            if (this.javaWSDLParam.getServerSide() == 4) {
                if (wscext.getComponentScopedRefs().size() > 0) {
                    this.compScopedRef = (ComponentScopedRefs)wscext.getComponentScopedRefs().get(0);
                }
            } else if (wscext.getServiceRefs().size() > 0) {
                this.newServiceRefs = wscext.getServiceRefs();
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateServiceRef6() throws Exception {
        WscextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
            WsClientExtension wscext = artifactEdit.getWsClientExtension();
            if (this.compScopedRef != null) {
                boolean processed = false;
                EList eList = wscext.getComponentScopedRefs();
                int i = 0;
                while (i < eList.size()) {
                    ComponentScopedRefs compScopedRefTemp = (ComponentScopedRefs)eList.get(i);
                    if (compScopedRefTemp != null && compScopedRefTemp.getComponentNameLink().equalsIgnoreCase(this.compScopedRef.getComponentNameLink())) {
                        this.newServiceRefs = this.compScopedRef.getServiceRefs();
                        int n = 0;
                        while (n < this.newServiceRefs.size()) {
                            ServiceRef newServiceRef = (ServiceRef)this.newServiceRefs.get(n);
                            EList serviceRefs = compScopedRefTemp.getServiceRefs();
                            int j = 0;
                            while (j < serviceRefs.size()) {
                                ServiceRef serviceRefTemp = (ServiceRef)serviceRefs.get(j);
                                if (serviceRefTemp != null && serviceRefTemp.getServiceRefLink().equalsIgnoreCase(newServiceRef.getServiceRefLink())) {
                                    serviceRefs.remove((Object)serviceRefTemp);
                                }
                                ++j;
                            }
                            serviceRefs.add((Object)EcoreUtil.copy((EObject)newServiceRef));
                            processed = true;
                            ++n;
                        }
                    }
                    ++i;
                }
                if (!processed) {
                    eList.add((Object)this.compScopedRef);
                }
            } else {
                int n = 0;
                while (n < this.newServiceRefs.size()) {
                    ServiceRef newServiceRef = (ServiceRef)this.newServiceRefs.get(n);
                    EList eList = wscext.getServiceRefs();
                    int i = 0;
                    while (i < eList.size()) {
                        ServiceRef serviceRefTemp = (ServiceRef)eList.get(i);
                        if (serviceRefTemp != null && serviceRefTemp.getServiceRefLink().equalsIgnoreCase(newServiceRef.getServiceRefLink())) {
                            eList.remove((Object)serviceRefTemp);
                        }
                        ++i;
                    }
                    eList.add((Object)EcoreUtil.copy((EObject)newServiceRef));
                    ++n;
                }
            }
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateServiceRef5() throws Exception {
        WscextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.proxyProject);
            WsClientExtension wscext = artifactEdit.getWsClientExtension();
            if (this.compScopedRef != null) {
                boolean processed = false;
                EList eList = wscext.getComponentScopedRefs();
                int i = 0;
                while (i < eList.size()) {
                    ComponentScopedRefs compScopedRefTemp = (ComponentScopedRefs)eList.get(i);
                    if (compScopedRefTemp != null && compScopedRefTemp.getComponentNameLink().equalsIgnoreCase(this.compScopedRef.getComponentNameLink())) {
                        this.newServiceRefs = this.compScopedRef.getServiceRefs();
                        int n = 0;
                        while (n < this.newServiceRefs.size()) {
                            ServiceRef newServiceRef = (ServiceRef)this.newServiceRefs.get(n);
                            EList serviceRefs = compScopedRefTemp.getServiceRefs();
                            int j = 0;
                            while (j < serviceRefs.size()) {
                                ServiceRef serviceRefTemp = (ServiceRef)serviceRefs.get(j);
                                if (serviceRefTemp != null && serviceRefTemp.getServiceRefLink().equalsIgnoreCase(newServiceRef.getServiceRefLink())) {
                                    serviceRefs.remove((Object)serviceRefTemp);
                                }
                                ++j;
                            }
                            serviceRefs.add((Object)EcoreUtil.copy((EObject)newServiceRef));
                            processed = true;
                            ++n;
                        }
                    }
                    ++i;
                }
                if (!processed) {
                    eList.add((Object)this.compScopedRef);
                }
            } else {
                int n = 0;
                while (n < this.newServiceRefs.size()) {
                    ServiceRef newServiceRef = (ServiceRef)this.newServiceRefs.get(n);
                    EList eList = wscext.getServiceRefs();
                    int i = 0;
                    while (i < eList.size()) {
                        ServiceRef serviceRefTemp = (ServiceRef)eList.get(i);
                        if (serviceRefTemp != null && serviceRefTemp.getServiceRefLink().equalsIgnoreCase(newServiceRef.getServiceRefLink())) {
                            eList.remove((Object)serviceRefTemp);
                        }
                        ++i;
                    }
                    eList.add((Object)EcoreUtil.copy((EObject)newServiceRef));
                    ++n;
                }
            }
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getWSCDDFilePath() {
        IPath projectPath = this.proxyProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proxyProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "WEB-INF";
        } else if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "META-INF";
            this.isEjb = true;
        } else if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
            this.infDir = "META-INF";
        } else {
            return;
        }
        IVirtualFile ivFile = ivFolder.getFile("webservicesclient.xml");
        if (ivFile.exists()) {
            this.webservicesClientXmlPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile(IBM_WEBSERVICESCLIENT_EXT_XMI)).exists()) {
            this.ibmWebServicesClientExtXmiPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.isContainerless = javaWSDLParam != null && javaWSDLParam.getContainer() != null && javaWSDLParam.getContainer().equalsIgnoreCase("none");
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setComponentScopedReference(String componentScopedReference) {
        this.componentScopedReference = componentScopedReference;
    }
}

