/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.JaxRPCMapArtifactEdit;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResourceFactory;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.PackageMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceEndpointInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLPortType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class RetrieveJAXRPCMappingInfoCommand
extends AbstractDataModelOperation {
    private IProject project = null;
    private JavaWSDLParameterBase javaWSDLParam = null;
    private boolean isContainerless = false;
    private Hashtable namespaceToPackageMapping = new Hashtable();
    private Hashtable portTypeToSEIMapping = new Hashtable();
    private String JaxRpcMappingFileRuntimePath = null;
    private String jaxrpcMappingFilePath_ = null;
    private JaxrpcmapResource jaxRPCMappingFile = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.javaWSDLParam.getTempOutput() != null && !this.isContainerless) {
                CopyJAXRPCMappingFileUtil.copyJaxRpcMappingFile((IEnvironment)super.getEnvironment(), (IProgressMonitor)monitor, (JavaWSDLParameterBase)this.javaWSDLParam, (boolean)this.isMetaInf());
                status = this.loadFromProject();
            } else if (this.javaWSDLParam.getTempOutput() != null && this.isContainerless) {
                this.loadFromTempDir(this.javaWSDLParam.getTempOutput());
            } else {
                status = this.loadFromProject();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return status;
    }

    private IStatus loadFromTempDir(String rootPath) {
        try {
            String filePath;
            J2EEInit.init();
            String infFolder = this.getInfFolderName();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
            URIConverterImpl conv = new URIConverterImpl();
            resourceSet.setURIConverter((URIConverter)conv);
            String mappingFileName = this.getJaxRpcMappingFileName(this.javaWSDLParam.getInputWsdlLocation());
            this.jaxrpcMappingFilePath_ = filePath = String.valueOf(rootPath) + infFolder + File.separator + mappingFileName;
            filePath = J2EEUtils.removeFileProtocol((String)filePath);
            URI uri = URI.createFileURI((String)filePath);
            J2EEResourceFactoryRegistry registry = (J2EEResourceFactoryRegistry)resourceSet.getResourceFactoryRegistry();
            registry.registerLastFileSegment(uri.lastSegment(), (Resource.Factory)new JaxrpcmapResourceFactory((RendererFactory)new EMF2DOMRendererFactory()));
            this.jaxRPCMappingFile = (JaxrpcmapResource)resourceSet.getResource(uri, true);
            this.populateMappingData(this.jaxRPCMappingFile);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    private IStatus loadFromProject() {
        JaxRPCMapArtifactEdit jaxrpcArtifactEdit = null;
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
            jaxrpcArtifactEdit = JaxRPCMapArtifactEdit.getJaxRPCMapArtifactEditForRead((IVirtualComponent)component);
            String mappingFileName = this.getJaxRpcMappingFileName(this.javaWSDLParam.getInputWsdlLocation());
            IVirtualFolder infFolder = this.getInfFolder();
            if (infFolder == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                IVirtualFile mappingFile = infFolder.getFile(mappingFileName);
                if (mappingFile != null && mappingFile.exists()) {
                    this.JaxRpcMappingFileRuntimePath = mappingFile.getRuntimePath().toString();
                    IPath path = this.project.getFullPath();
                    path = path.append(mappingFile.getProjectRelativePath());
                    String testUri = path.toString();
                    this.jaxRPCMappingFile = jaxrpcArtifactEdit.getJaxRPCMapXmiResource(testUri);
                    this.populateMappingData(this.jaxRPCMappingFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (jaxrpcArtifactEdit != null) {
                jaxrpcArtifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private void populateMappingData(JaxrpcmapResource jaxrpcmapRes) {
        JavaWSDLMapping j2wMap = jaxrpcmapRes.getJavaWSDLMapping();
        EList mappings = j2wMap.getPackageMappings();
        int i = 0;
        while (i < mappings.size()) {
            PackageMapping packMap = (PackageMapping)mappings.get(i);
            this.namespaceToPackageMapping.put(packMap.getNamespaceURI(), packMap.getPackageType() == null ? "" : packMap.getPackageType());
            ++i;
        }
        mappings = j2wMap.getInterfaceMappings();
        i = 0;
        while (i < mappings.size()) {
            if (mappings.get(i) instanceof ServiceEndpointInterfaceMapping) {
                ServiceEndpointInterfaceMapping seiMap = (ServiceEndpointInterfaceMapping)mappings.get(i);
                WSDLPortType wsdlPortType = seiMap.getWsdlPortType();
                this.portTypeToSEIMapping.put(String.valueOf(wsdlPortType.getNamespaceURI()) + ":" + wsdlPortType.getLocalPart(), seiMap.getServiceEndpointInterface());
            }
            ++i;
        }
    }

    private boolean isMetaInf() {
        if (J2EEUtils.isWebProject((IProject)this.project)) {
            return false;
        }
        return J2EEUtils.isEJBProject((IProject)this.project) || J2EEUtils.isAppClientProject((IProject)this.project);
    }

    private String getInfFolderName() {
        if (J2EEUtils.isWebProject((IProject)this.project)) {
            return "WEB-INF";
        }
        if (J2EEUtils.isEJBProject((IProject)this.project) || J2EEUtils.isAppClientProject((IProject)this.project)) {
            return "META-INF";
        }
        return "META-INF";
    }

    private IVirtualFolder getInfFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isAppClientProject((IProject)this.project)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
        } else {
            return null;
        }
        return ivFolder;
    }

    private String getJaxRpcMappingFileName(String uri) {
        String wsdlName = WSDLUtils.getName(uri).trim();
        if (wsdlName.toLowerCase().endsWith(".wsdl")) {
            int lastDot = wsdlName.lastIndexOf(".");
            wsdlName = String.valueOf(wsdlName.substring(0, lastDot)) + "_mapping.xml";
        } else {
            wsdlName = String.valueOf(wsdlName) + "_mapping.xml";
        }
        return wsdlName;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Hashtable getNamespaceToPackageMapping() {
        return this.namespaceToPackageMapping;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.isContainerless = javaWSDLParam != null && javaWSDLParam.getContainer() != null && javaWSDLParam.getContainer().equalsIgnoreCase("none");
    }

    public String getJaxrpcMappingFilePath() {
        return this.jaxrpcMappingFilePath_;
    }

    public Hashtable getPortTypeToSEIMapping() {
        return this.portTypeToSEIMapping;
    }

    public String getMappingFile() {
        return this.JaxRpcMappingFileRuntimePath.substring(1);
    }

    public final JaxrpcmapResource getJaxRPCMappingFile() {
        return this.jaxRPCMappingFile;
    }

    public void setJaxRPCMappingFile(JaxrpcmapResource jaxRPCMappingFile) {
        this.jaxRPCMappingFile = jaxRPCMappingFile;
    }
}

