/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DefaultsForClientJavaWSDLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    IProject proxyProject;
    byte webServiceSecurityConfig;
    String wSDLServicePathname;
    String wSDLServiceURL;
    boolean isWebServiceSecured;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = super.getEnvironment();
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        IProject project = this.proxyProject;
        this.javaWSDLParam.setProject(project);
        this.javaWSDLParam.setMetaInfOnly(false);
        if (J2EEUtils.isWebProject((IProject)project)) {
            this.javaWSDLParam.setServerSide((byte)0);
        } else if (J2EEUtils.isEJBProject((IProject)project)) {
            this.javaWSDLParam.setServerSide((byte)4);
        } else if (J2EEUtils.isAppClientProject((IProject)project)) {
            this.javaWSDLParam.setServerSide((byte)5);
        } else {
            this.javaWSDLParam.setServerSide((byte)3);
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String output = this.javaWSDLParam.getJavaOutput();
        if (this.javaWSDLParam.getJavaOutput() == null || this.javaWSDLParam.getDevelopServerJavaOutput() == null) {
            IPath developClientJavaOutputPath = null;
            developClientJavaOutputPath = this.javaWSDLParam.getServerSide() == 4 ? J2EEUtils.getEJBJavaSourceLocation((IVirtualComponent)component) : J2EEUtils.getJavaSourceLocation((IProject)project);
            if (developClientJavaOutputPath == null) {
                return StatusUtils.errorStatus((String)Messages.MSG_ERROR_DEFAULT_BEAN);
            }
            IPath javaOutputPath = developClientJavaOutputPath;
            this.javaWSDLParam.setDevelopServerJavaOutput(PlatformUtils.getPlatformURL(developClientJavaOutputPath));
            output = PlatformUtils.getPlatformURL(javaOutputPath);
            this.javaWSDLParam.setJavaOutput(output);
        }
        if (component != null) {
            IPath outputPath = project.getFullPath();
            IVirtualFolder ivFolder = component.getRootFolder();
            outputPath = outputPath.append(ivFolder.getProjectRelativePath());
            output = PlatformUtils.getPlatformURL(outputPath);
        }
        this.javaWSDLParam.setOutput(output);
        this.javaWSDLParam.setTempOutput(J2EEUtils.getFileURL((File)J2EEUtils.createTempDir()));
        if (this.wSDLServicePathname == null) {
            if (this.wSDLServiceURL == null) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_WSDL_LOCATION_NOT_SET);
                environment.getStatusHandler().reportError(status);
                return status;
            }
        } else {
            this.wSDLServiceURL = PlatformUtils.getFileFromPlatform(this.wSDLServicePathname);
        }
        this.javaWSDLParam.setInputWsdlLocation(this.wSDLServiceURL);
        this.javaWSDLParam.setNoDataBinding(WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoDataBindings());
        return Status.OK_STATUS;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setWebServiceSecurityConfig(byte webServiceSecurityConfig) {
        this.webServiceSecurityConfig = webServiceSecurityConfig;
    }

    public void setWSDLServicePathname(String servicePathname) {
        this.wSDLServicePathname = servicePathname;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.wSDLServiceURL = serviceURL;
    }

    public void setIsWebServiceSecured(boolean isWebServiceSecured) {
        this.isWebServiceSecured = isWebServiceSecured;
    }

    public String getSetEndpointMethodName() {
        return "setEndpoint";
    }

    public AbstractEmitterCommand getNullJava2WsdlCommand() {
        return null;
    }
}

