/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.environment.ui.common.ResourceUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CreateTempClientDeploymentFilesCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webXmlPath = null;
    IPath webTempXmlPath = null;
    IPath webServicesClientXmlPath = null;
    IPath webServicesClientTempXmlPath = null;
    IPath ibmWebServicesClientBndXmiPath = null;
    IPath ibmWebServicesClientBndTempXmiPath = null;
    IPath ibmWebServicesClientExtXmiPath = null;
    IPath ibmWebServicesClientExtTempXmiPath = null;
    IPath ddPath = null;
    private String infDir = null;
    private String ddName = null;
    private IProject proxyProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        IProject wscXmlProject = this.proxyProject;
        if (wscXmlProject == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
        }
        IEnvironment env = super.getEnvironment();
        try {
            this.getWSCDDFilePath();
            if (this.javaWSDLParam.getJ2eeLevel().equals("1.4") && this.ddPath != null) {
                IFile file = (IFile)ResourceUtils.findResource((String)this.ddPath.makeAbsolute().toString());
                InputStream is = null;
                if (file != null) {
                    is = file.getContents();
                }
                this.copyTemplateToTempDirectory(is, this.ddName, env, monitor);
            }
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)(String.valueOf(Messages.MSG_ERROR_PARSING_WEBSERVICES_XML) + ": " + e), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void copyTemplateToTempDirectory(InputStream is, String fileName, IEnvironment env, IProgressMonitor monitor) {
        try {
            String inputLine;
            String tempDir = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
            File file = new File(String.valueOf(tempDir) + this.infDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(tempDir) + this.infDir + File.separator + fileName);
            DataInputStream dis = new DataInputStream(is);
            while ((inputLine = dis.readLine()) != null) {
                fw.write(inputLine);
                fw.write(10);
            }
            fw.flush();
            fw.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void getWSCDDFilePath() {
        IPath projectPath = this.proxyProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proxyProject);
        IVirtualFolder ivFolder = null;
        IVirtualFile ivFile = null;
        if (J2EEUtils.isWebProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            ivFile = ivFolder.getFile("web.xml");
            this.infDir = "WEB-INF";
            this.ddName = "web.xml";
        } else if (J2EEUtils.isEJBProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
            ivFile = ivFolder.getFile("ejb-jar.xml");
            this.infDir = "META-INF";
            this.ddName = "ejb-jar.xml";
        } else if (J2EEUtils.isAppClientProject((IProject)this.proxyProject)) {
            ivFolder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
            ivFile = ivFolder.getFile("application-client.xml");
            this.infDir = "META-INF";
            this.ddName = "application-client.xml";
        } else {
            return;
        }
        if (ivFile.exists()) {
            this.ddPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public static void moveIFile(IWorkspaceRoot root, IPath sourcePath, IPath destPath) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IResource sourceRes = CreateTempClientDeploymentFilesCommand.getResourceForLocation(root, sourcePath);
        if (sourceRes != null) {
            IResource destRes = CreateTempClientDeploymentFilesCommand.getResourceForLocation(root, destPath);
            if (destRes == null) {
                sourceRes.copy(destPath, 2, (IProgressMonitor)monitor);
            } else if (sourceRes instanceof IFile && destRes instanceof IFile) {
                ((IFile)destRes).setContents(((IFile)sourceRes).getContents(), true, true, (IProgressMonitor)monitor);
                ((IFile)sourceRes).delete(2, (IProgressMonitor)monitor);
            }
        }
    }

    private static IResource getResourceForLocation(IWorkspaceRoot root, IPath location) {
        IContainer res = root.getContainerForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        res = root.getFileForLocation(location);
        if (res != null && res.exists()) {
            return res;
        }
        return root.findMember(location, true);
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }
}

