/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.wsdl.factory.WSDLFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class CopyClientWSDLCommand
extends AbstractDataModelOperation {
    private String pluginId_ = "com.ibm.etools.webservice.was.consumption.ui";
    private String wsdlURL_;
    private String clientWSDLPathName_;
    private WebServicesParser wsParser_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        IStatus status = Status.OK_STATUS;
        Definition def = this.wsParser_.getWSDLDefinition(this.wsdlURL_);
        if (def == null) {
            status = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WSDL_NO_DEFINITION, (Object[])new String[]{this.wsdlURL_}));
            env.getStatusHandler().reportError(status);
            return status;
        }
        Path clientWSDLPath = new Path(this.clientWSDLPathName_);
        IWorkspaceRoot workspaceRoot = FileResourceUtils.getWorkspaceRoot();
        status = this.resolveWSDL(workspaceRoot, def, (IPath)clientWSDLPath, env, monitor);
        return status;
    }

    private IStatus resolveWSDL(IWorkspaceRoot workspace, Definition wsdlDef, IPath wsdlPath, IEnvironment env, IProgressMonitor monitor) {
        try {
            this.writeWSDLFile(workspace, wsdlDef, wsdlPath, env, monitor);
            Map importDefs = wsdlDef.getImports();
            Set keysSet = importDefs.keySet();
            for (Object keyName : keysSet) {
                Vector vector = (Vector)importDefs.get(keyName);
                int i = 0;
                while (i < vector.size()) {
                    Import importDef = (Import)vector.get(i);
                    Definition def = importDef.getDefinition();
                    String newPathString = wsdlPath.toString().substring(0, wsdlPath.toString().lastIndexOf("/") + 1);
                    if (this.isInvalidImportWSDL(importDef.getLocationURI())) {
                        return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_IMPORT_WSDL, (Object[])new String[]{importDef.getLocationURI()}));
                    }
                    Path newPath = new Path(String.valueOf(newPathString) + importDef.getLocationURI());
                    IStatus status = this.resolveWSDL(workspace, def, (IPath)newPath, env, monitor);
                    if (status != null && status.getSeverity() == 4) {
                        return status;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WRITE_WSDL, (Object[])new String[]{wsdlPath.toString()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private boolean isInvalidImportWSDL(String wsdlPath) {
        return !wsdlPath.toLowerCase().startsWith("http://") && wsdlPath.indexOf("/") != -1 && !wsdlPath.startsWith("./");
    }

    private void writeWSDLFile(IWorkspaceRoot workspace, Definition wsdlDef, IPath wsdlPath, IEnvironment env, IProgressMonitor monitor) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WSDLWriter wsdlWriter = new WSDLFactoryImpl().newWSDLWriter();
        wsdlWriter.writeWSDL(wsdlDef, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ResourceContext context = ((BaseEclipseEnvironment)env).getResourceContext();
        FileResourceUtils.createFile((ResourceContext)context, (IPath)wsdlPath.makeAbsolute(), (InputStream)bais, (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        baos.close();
        bais.close();
    }

    public void setClientWSDLPathName(String clientWSDLPathName) {
        this.clientWSDLPathName_ = clientWSDLPathName;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL_ = wsdlURL;
    }

    public void setWsParser(WebServicesParser wsParser) {
        this.wsParser_ = wsParser;
    }
}

