/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.consumption.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class AddFacetToJavaProjectCommand
extends AbstractDataModelOperation {
    private IProject proxyProject;
    private String clientServerTypeId;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFacetedProject facetProj = null;
        if (this.proxyProject.exists()) {
            try {
                facetProj = ProjectFacetsManager.create((IProject)this.proxyProject);
                if (facetProj == null || !J2EEUtils.isWebProject((IProject)this.proxyProject) && !J2EEUtils.isEJBProject((IProject)this.proxyProject) && !J2EEUtils.isAppClientProject((IProject)this.proxyProject) && !J2EEUtils.isJavaUtilityProject((IProject)this.proxyProject)) {
                    return this.addClassPathToProject(monitor);
                }
            }
            catch (Exception ce) {
                ce.printStackTrace(System.err);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus addClassPathToProject(IProgressMonitor monitor) throws CoreException {
        IServerType serverType = ServerCore.findServerType((String)this.clientServerTypeId);
        String variableName = null;
        if (serverType != null) {
            IRuntimeType runtimeType = serverType.getRuntimeType();
            if (WASRuntimeUtil.isWASv60RuntimeType((IRuntimeType)runtimeType)) {
                if (RdPlugin.getDefault().isV6ThinClientClasspathSet()) {
                    variableName = "WAS_V6_WEBSERVICES_THINCLIENT";
                } else if (!RdPlugin.getDefault().setUpV6ClassPathVariable(false)) {
                    if (!RdPlugin.getDefault().isV61ThinClientClasspathSet() && !RdPlugin.getDefault().setUpV61ClassPathVariable()) {
                        return StatusUtils.errorStatus((String)Messages.MSG_ERROR_THINCLIENT_REQUIRED);
                    }
                    variableName = "WAS_V61_WEBSERVICES_THINCLIENT";
                } else {
                    variableName = "WAS_V6_WEBSERVICES_THINCLIENT";
                }
            } else if (WASRuntimeUtil.isWASv61RuntimeType((IRuntimeType)runtimeType)) {
                if (!RdPlugin.getDefault().isV61ThinClientClasspathSet()) {
                    RdPlugin.getDefault().setUpV61ClassPathVariable();
                }
                variableName = "WAS_V61_WEBSERVICES_THINCLIENT";
            } else if (WASRuntimeUtil.isWASv70RuntimeType((IRuntimeType)runtimeType)) {
                if (!RdPlugin.getDefault().isV7ThinClientClasspathSet()) {
                    RdPlugin.getDefault().setUpV7ClassPathVariable();
                }
                variableName = "WAS_V7_WEBSERVICES_THINCLIENT";
            }
        } else {
            return StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_SERVERTYPE_NOT_FOUND, (Object)this.clientServerTypeId));
        }
        if (variableName == null) {
            return StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_THINCLIENT_VAR_NOT_FOUND, (Object)this.clientServerTypeId));
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.proxyProject);
        IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
        Path desiredPath = new Path(variableName);
        int i = 0;
        while (i < classPathEntries.length) {
            IPath path;
            IClasspathEntry classpathEntry = classPathEntries[i];
            if (classpathEntry.getEntryKind() == 4 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                return Status.OK_STATUS;
            }
            ++i;
        }
        IClasspathEntry thinClientClassPathEntry = JavaCore.newVariableEntry((IPath)desiredPath, null, null);
        IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + 1];
        newClassPathEntries[0] = thinClientClassPathEntry;
        int i2 = 0;
        while (i2 < classPathEntries.length) {
            newClassPathEntries[i2 + 1] = classPathEntries[i2];
            ++i2;
        }
        javaProject.setRawClasspath(newClassPathEntries, monitor);
        return Status.OK_STATUS;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setClientServerTypeID(String clientServerTypeId) {
        this.clientServerTypeId = clientServerTypeId;
    }
}

